<?php $__env->startSection('title', 'Investments'); ?>


<?php $content = app('App\Http\Controllers\FrontController'); ?>
<?php $__env->startSection('content'); ?>


    <!-- Page Content -->
    <main class="flex-grow">
        <div class="animate-fade-in">
                <!-- Hero Section -->
    <section class="relative bg-horizon-700 py-20 md:py-28 overflow-hidden">
        <div class="absolute inset-0 bg-gradient-to-r from-horizon-800 to-horizon-700 opacity-90"></div>
        <div class="absolute inset-0 opacity-20">
            <div class="absolute top-10 left-10 w-32 h-32 bg-gold-500 rounded-full animate-pulse"></div>
            <div class="absolute bottom-20 right-20 w-24 h-24 bg-gold-400 rounded-full animate-pulse delay-1000"></div>
        </div>

        <div class="container mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            <div class="max-w-4xl mx-auto">
                <div class="flex flex-col md:flex-row justify-between items-center">
                    <div class="mb-8 md:mb-0">
                        <h1 class="text-4xl md:text-5xl lg:text-6xl font-display font-bold text-white leading-tight">
                            Our <span class="text-gold-500">Services</span>
                        </h1>
                        <nav class="flex mt-6" aria-label="Breadcrumb">
                            <ol class="flex items-center space-x-2 text-white text-opacity-80">
                                <li>
                                    <a href="index" class="hover:text-gold-400 transition-colors duration-200">Home</a>
                                </li>
                                <li class="flex items-center">
                                    <svg class="h-5 w-5 text-gold-500 mx-1" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path>
                                    </svg>
                                    <a href="#" class="hover:text-gold-400 transition-colors duration-200">Services</a>
                                </li>
                                <li class="flex items-center">
                                    <svg class="h-5 w-5 text-gold-500 mx-1" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path>
                                    </svg>
                                    <span class="text-gold-400">Service Details</span>
                                </li>
                            </ol>
                        </nav>
                    </div>
                    <div class="hidden md:block">
                        <img src="assets/img/service/breadcrumb-12.png" alt="Service" class="max-w-xs h-auto animate-bounce-slow">
                    </div>
                </div>
            </div>
        </div>
        <div class="absolute bottom-0 left-0 right-0 h-16 bg-gradient-to-t from-white to-transparent"></div>
    </section>

    <!-- Service Details Section -->
    <section class="py-16 bg-white">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="max-w-7xl mx-auto">
                <!-- Trading Services Overview -->
                <div class="text-center mb-16">
                    <span class="text-gold-500 font-semibold text-sm tracking-wider uppercase">Complete Trading Solutions</span>
                    <h2 class="text-4xl md:text-5xl font-display font-bold text-horizon-800 mt-3 mb-4">Explore Our Investment & Trading Services</h2>
                    <p class="text-secondary-600 text-lg max-w-3xl mx-auto">From automated trading to passive income strategies - discover powerful tools designed to grow your wealth</p>
                </div>

                <!-- Advanced Trading Features Grid -->
                <div class="grid grid-cols-1 md:grid-cols-3 gap-8 mb-16">
                    <!-- Copy Trading -->
                    <div class="bg-gradient-to-br from-green-50 to-green-50 rounded-2xl p-8 shadow-lg hover:shadow-2xl transition-all duration-300 hover:-translate-y-2">
                        <div class="w-16 h-16 bg-gradient-to-br from-green-500 to-green-600 rounded-xl flex items-center justify-center mb-6">
                            <i class="fas fa-users text-white text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-horizon-800 mb-3">Copy Trading</h3>
                        <p class="text-secondary-700 mb-6">Automatically replicate trades from our 50+ verified expert traders. Earn while they earn with real-time profit distribution.</p>
                        <div class="space-y-3 mb-6">
                            <div class="flex items-center">
                                <i class="fas fa-check-circle text-green-500 mr-2"></i>
                                <span class="text-sm text-secondary-700">Real-time trade replication</span>
                            </div>
                            <div class="flex items-center">
                                <i class="fas fa-check-circle text-green-500 mr-2"></i>
                                <span class="text-sm text-secondary-700">Performance metrics tracking</span>
                            </div>
                            <div class="flex items-center">
                                <i class="fas fa-check-circle text-green-500 mr-2"></i>
                                <span class="text-sm text-secondary-700">Start from $100</span>
                            </div>
                        </div>
                        <div class="bg-white rounded-lg p-4 mb-4">
                            <div class="flex justify-between items-center mb-2">
                                <span class="text-sm text-secondary-600">Average ROI</span>
                                <span class="text-lg font-bold text-green-600">15-25%</span>
                            </div>
                            <div class="text-xs text-secondary-500">Per month</div>
                        </div>
                        <a href="<?php echo e(route('register')); ?>" class="block w-full text-center bg-green-600 hover:bg-green-700 text-white font-semibold py-3 rounded-lg transition-colors">
                            Start Copy Trading
                        </a>
                    </div>

                    <!-- Bot Trading -->
                    <div class="bg-gradient-to-br from-green-50 to-emerald-50 rounded-2xl p-8 shadow-lg hover:shadow-2xl transition-all duration-300 hover:-translate-y-2">
                        <div class="w-16 h-16 bg-gradient-to-br from-green-500 to-green-600 rounded-xl flex items-center justify-center mb-6">
                            <i class="fas fa-robot text-white text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-horizon-800 mb-3">Bot Trading</h3>
                        <p class="text-secondary-700 mb-6">Deploy AI-powered trading bots that work 24/7. Automated strategies with proven backtested results.</p>
                        <div class="space-y-3 mb-6">
                            <div class="flex items-center">
                                <i class="fas fa-check-circle text-green-500 mr-2"></i>
                                <span class="text-sm text-secondary-700">24/7 automated trading</span>
                            </div>
                            <div class="flex items-center">
                                <i class="fas fa-check-circle text-green-500 mr-2"></i>
                                <span class="text-sm text-secondary-700">Pre-configured strategies</span>
                            </div>
                            <div class="flex items-center">
                                <i class="fas fa-check-circle text-green-500 mr-2"></i>
                                <span class="text-sm text-secondary-700">Multiple risk levels</span>
                            </div>
                        </div>
                        <div class="bg-white rounded-lg p-4 mb-4">
                            <div class="flex justify-between items-center mb-2">
                                <span class="text-sm text-secondary-600">Average ROI</span>
                                <span class="text-lg font-bold text-green-600">18-32%</span>
                            </div>
                            <div class="text-xs text-secondary-500">Per year</div>
                        </div>
                        <a href="<?php echo e(route('register')); ?>" class="block w-full text-center bg-green-600 hover:bg-green-700 text-white font-semibold py-3 rounded-lg transition-colors">
                            Activate Bot Trading
                        </a>
                    </div>

                    <!-- Crypto Staking -->
                    <div class="bg-gradient-to-br from-green-50 to-pink-50 rounded-2xl p-8 shadow-lg hover:shadow-2xl transition-all duration-300 hover:-translate-y-2">
                        <div class="w-16 h-16 bg-gradient-to-br from-green-500 to-green-600 rounded-xl flex items-center justify-center mb-6">
                            <i class="fas fa-coins text-white text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-horizon-800 mb-3">Crypto Staking</h3>
                        <p class="text-secondary-700 mb-6">Earn passive rewards by staking cryptocurrencies. Flexible and fixed lock periods with competitive APR.</p>
                        <div class="space-y-3 mb-6">
                            <div class="flex items-center">
                                <i class="fas fa-check-circle text-green-500 mr-2"></i>
                                <span class="text-sm text-secondary-700">Up to 15% APR returns</span>
                            </div>
                            <div class="flex items-center">
                                <i class="fas fa-check-circle text-green-500 mr-2"></i>
                                <span class="text-sm text-secondary-700">Daily reward distribution</span>
                            </div>
                            <div class="flex items-center">
                                <i class="fas fa-check-circle text-green-500 mr-2"></i>
                                <span class="text-sm text-secondary-700">Flexible withdrawal</span>
                            </div>
                        </div>
                        <div class="bg-white rounded-lg p-4 mb-4">
                            <div class="flex justify-between items-center mb-2">
                                <span class="text-sm text-secondary-600">APR Range</span>
                                <span class="text-lg font-bold text-green-600">5-15%</span>
                            </div>
                            <div class="text-xs text-secondary-500">Annually</div>
                        </div>
                        <a href="<?php echo e(route('register')); ?>" class="block w-full text-center bg-green-600 hover:bg-green-700 text-white font-semibold py-3 rounded-lg transition-colors">
                            Start Staking Now
                        </a>
                    </div>
                </div>

                <!-- Complete Trading Ecosystem -->
                <div class="mb-16">
                    <h3 class="text-3xl font-display font-bold text-horizon-800 mb-8 text-center">Complete Trading Ecosystem</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                        <!-- Stock Trading -->
                        <div class="bg-white rounded-xl p-6 border-2 border-gray-200 hover:border-green-400 hover:shadow-lg transition-all">
                            <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center mb-4">
                                <i class="fas fa-chart-line text-green-600 text-xl"></i>
                            </div>
                            <h4 class="text-lg font-bold text-horizon-800 mb-2">Stock Trading</h4>
                            <p class="text-sm text-secondary-600 mb-3">Trade global stocks with real-time quotes and instant execution</p>
                            <ul class="space-y-1 text-xs text-secondary-700">
                                <li><i class="fas fa-dot-circle text-green-500 mr-1"></i>Real-time data</li>
                                <li><i class="fas fa-dot-circle text-green-500 mr-1"></i>Technical analysis</li>
                                <li><i class="fas fa-dot-circle text-green-500 mr-1"></i>Low fees</li>
                            </ul>
                        </div>

                        <!-- Stock Investment -->
                        <div class="bg-white rounded-xl p-6 border-2 border-gray-200 hover:border-green-400 hover:shadow-lg transition-all">
                            <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center mb-4">
                                <i class="fas fa-briefcase text-green-600 text-xl"></i>
                            </div>
                            <h4 class="text-lg font-bold text-horizon-800 mb-2">Stock Investment</h4>
                            <p class="text-sm text-secondary-600 mb-3">Long-term wealth building with portfolio management tools</p>
                            <ul class="space-y-1 text-xs text-secondary-700">
                                <li><i class="fas fa-dot-circle text-green-500 mr-1"></i>Portfolio tracking</li>
                                <li><i class="fas fa-dot-circle text-green-500 mr-1"></i>Dividend management</li>
                                <li><i class="fas fa-dot-circle text-green-500 mr-1"></i>Risk assessment</li>
                            </ul>
                        </div>

                        <!-- Crypto Exchange -->
                        <div class="bg-white rounded-xl p-6 border-2 border-gray-200 hover:border-orange-400 hover:shadow-lg transition-all">
                            <div class="w-12 h-12 bg-orange-100 rounded-lg flex items-center justify-center mb-4">
                                <i class="fab fa-bitcoin text-orange-600 text-xl"></i>
                            </div>
                            <h4 class="text-lg font-bold text-horizon-800 mb-2">Crypto Exchange</h4>
                            <p class="text-sm text-secondary-600 mb-3">Trade 100+ cryptocurrencies with deep liquidity</p>
                            <ul class="space-y-1 text-xs text-secondary-700">
                                <li><i class="fas fa-dot-circle text-orange-500 mr-1"></i>100+ crypto pairs</li>
                                <li><i class="fas fa-dot-circle text-orange-500 mr-1"></i>Instant deposits</li>
                                <li><i class="fas fa-dot-circle text-orange-500 mr-1"></i>Cold storage</li>
                            </ul>
                        </div>

                        <!-- Forex Trading -->
                        <div class="bg-white rounded-xl p-6 border-2 border-gray-200 hover:border-teal-400 hover:shadow-lg transition-all">
                            <div class="w-12 h-12 bg-teal-100 rounded-lg flex items-center justify-center mb-4">
                                <i class="fas fa-dollar-sign text-teal-600 text-xl"></i>
                            </div>
                            <h4 class="text-lg font-bold text-horizon-800 mb-2">Forex Trading</h4>
                            <p class="text-sm text-secondary-600 mb-3">50+ currency pairs with competitive spreads</p>
                            <ul class="space-y-1 text-xs text-secondary-700">
                                <li><i class="fas fa-dot-circle text-teal-500 mr-1"></i>Major & exotic pairs</li>
                                <li><i class="fas fa-dot-circle text-teal-500 mr-1"></i>Leverage up to 1:500</li>
                                <li><i class="fas fa-dot-circle text-teal-500 mr-1"></i>MT4/MT5 support</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="grid grid-cols-1 lg:grid-cols-3 gap-12">
                    <!-- Main Content -->
                    <div class="lg:col-span-2">
                        <!-- Platform Features -->
                        <!-- Platform Features -->
                        <div class="bg-white rounded-2xl shadow-xl overflow-hidden mb-8">
                            <div class="relative">
                                <img src="assets/img/service/single-service-1.jpg" alt="Trading Platform" class="w-full h-64 object-cover">
                                <div class="absolute inset-0 bg-gradient-to-t from-horizon-900 via-horizon-900/50 to-transparent flex items-end">
                                    <div class="p-6">
                                        <h2 class="text-3xl font-display font-bold text-white mb-2">Advanced Trading Platform</h2>
                                        <p class="text-gray-200">Professional tools for every trading style</p>
                                    </div>
                                </div>
                            </div>
                            <div class="p-8">
                                <h3 class="text-2xl font-display font-bold text-horizon-800 mb-6">Why Choose <?php echo e($settings->site_name); ?>?</h3>
                                
                                <!-- Key Benefits -->
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                                    <div class="flex items-start">
                                        <div class="flex-shrink-0 w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-4">
                                            <i class="fas fa-shield-alt text-green-600"></i>
                                        </div>
                                        <div>
                                            <h4 class="font-bold text-horizon-800 mb-1">Bank-Grade Security</h4>
                                            <p class="text-sm text-secondary-600">256-bit encryption, 2FA, and cold storage protection</p>
                                        </div>
                                    </div>
                                    <div class="flex items-start">
                                        <div class="flex-shrink-0 w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-4">
                                            <i class="fas fa-bolt text-green-600"></i>
                                        </div>
                                        <div>
                                            <h4 class="font-bold text-horizon-800 mb-1">Lightning Fast</h4>
                                            <p class="text-sm text-secondary-600">Sub-second execution with 99.9% uptime</p>
                                        </div>
                                    </div>
                                    <div class="flex items-start">
                                        <div class="flex-shrink-0 w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-4">
                                            <i class="fas fa-mobile-alt text-green-600"></i>
                                        </div>
                                        <div>
                                            <h4 class="font-bold text-horizon-800 mb-1">Trade Anywhere</h4>
                                            <p class="text-sm text-secondary-600">iOS & Android apps with full functionality</p>
                                        </div>
                                    </div>
                                    <div class="flex items-start">
                                        <div class="flex-shrink-0 w-10 h-10 bg-orange-100 rounded-lg flex items-center justify-center mr-4">
                                            <i class="fas fa-headset text-orange-600"></i>
                                        </div>
                                        <div>
                                            <h4 class="font-bold text-horizon-800 mb-1">24/7 Support</h4>
                                            <p class="text-sm text-secondary-600">Expert assistance available around the clock</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="bg-gradient-to-r from-gold-50 to-yellow-50 rounded-xl p-6 mb-8 border-2 border-gold-200">
                                    <div class="flex items-center mb-4">
                                        <i class="fas fa-star text-gold-500 text-2xl mr-3"></i>
                                        <h4 class="text-xl font-bold text-horizon-800">Special Offer for New Users</h4>
                                    </div>
                                    <p class="text-secondary-700 mb-4">Start trading with us and receive up to $500 welcome bonus on your first deposit!</p>
                                    <a href="<?php echo e(route('register')); ?>" class="inline-flex items-center px-6 py-3 bg-gold-500 hover:bg-gold-600 text-white font-semibold rounded-lg transition-all">
                                        <i class="fas fa-gift mr-2"></i>
                                        Claim Bonus Now
                                    </a>
                                </div>

                                <h3 class="text-2xl font-display font-bold text-horizon-800 mb-4">How It Works</h3>
                                <p class="text-secondary-700 mb-6">
                                    <?php echo e($settings->site_name); ?> provides a comprehensive trading ecosystem that combines traditional and modern investment methods. Whether you prefer hands-on trading or fully automated strategies, we have the perfect solution for you.
                                </p>

                                <div class="space-y-4 mb-8">
                                    <div class="flex items-start">
                                        <div class="flex-shrink-0 w-8 h-8 bg-green-500 rounded-full flex items-center justify-center text-white font-bold mr-4 mt-1">1</div>
                                        <div>
                                            <h5 class="font-bold text-horizon-800 mb-1">Create Your Account</h5>
                                            <p class="text-secondary-600">Sign up in 30 seconds with email verification and quick KYC</p>
                                        </div>
                                    </div>
                                    <div class="flex items-start">
                                        <div class="flex-shrink-0 w-8 h-8 bg-green-500 rounded-full flex items-center justify-center text-white font-bold mr-4 mt-1">2</div>
                                        <div>
                                            <h5 class="font-bold text-horizon-800 mb-1">Fund Your Wallet</h5>
                                            <p class="text-secondary-600">Deposit via crypto, bank transfer, or card - starting from just $50</p>
                                        </div>
                                    </div>
                                    <div class="flex items-start">
                                        <div class="flex-shrink-0 w-8 h-8 bg-green-500 rounded-full flex items-center justify-center text-white font-bold mr-4 mt-1">3</div>
                                        <div>
                                            <h5 class="font-bold text-horizon-800 mb-1">Choose Your Strategy</h5>
                                            <p class="text-secondary-600">Select copy trading, bot trading, manual trading, or staking</p>
                                        </div>
                                    </div>
                                    <div class="flex items-start">
                                        <div class="flex-shrink-0 w-8 h-8 bg-gold-500 rounded-full flex items-center justify-center text-white font-bold mr-4 mt-1">4</div>
                                        <div>
                                            <h5 class="font-bold text-horizon-800 mb-1">Start Earning</h5>
                                            <p class="text-secondary-600">Watch your investments grow with real-time tracking and analytics</p>
                                        </div>
                                    </div>
                                </div>

                                <h3 class="text-2xl font-display font-bold text-horizon-800 mb-4">Platform Statistics</h3>
                                <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-8">
                                    <div class="text-center p-4 bg-green-50 rounded-lg">
                                        <div class="text-3xl font-bold text-green-600 mb-1">15K+</div>
                                        <div class="text-xs text-secondary-600">Active Traders</div>
                                    </div>
                                    <div class="text-center p-4 bg-green-50 rounded-lg">
                                        <div class="text-3xl font-bold text-green-600 mb-1">$2.5M+</div>
                                        <div class="text-xs text-secondary-600">Daily Volume</div>
                                    </div>
                                    <div class="text-center p-4 bg-green-50 rounded-lg">
                                        <div class="text-3xl font-bold text-green-600 mb-1">98.7%</div>
                                        <div class="text-xs text-secondary-600">Success Rate</div>
                                    </div>
                                    <div class="text-center p-4 bg-orange-50 rounded-lg">
                                        <div class="text-3xl font-bold text-orange-600 mb-1">24/7</div>
                                        <div class="text-xs text-secondary-600">Trading Access</div>
                                    </div>
                                </div>

                                <!-- FAQ Section -->
                                <h3 class="text-2xl font-display font-bold text-horizon-800 mb-6">Frequently Asked Questions</h3>
                                <div class="space-y-4" x-data="{selected:1}">
                                    <!-- Question 1 -->
                                    <div class="border border-gray-200 rounded-lg overflow-hidden">
                                        <button
                                            @click="selected !== 1 ? selected = 1 : selected = null"
                                            class="flex justify-between items-center w-full px-6 py-4 text-left text-horizon-800 font-medium hover:bg-gray-50 focus:outline-none"
                                        >
                                            <span>What trading methods are available?</span>
                                            <svg
                                                :class="{'rotate-180': selected === 1}"
                                                class="h-5 w-5 text-horizon-700 transform transition-transform duration-200"
                                                xmlns="http://www.w3.org/2000/svg"
                                                viewBox="0 0 20 20"
                                                fill="currentColor"
                                            >
                                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                            </svg>
                                        </button>
                                        <div
                                            x-show="selected === 1"
                                            x-transition:enter="transition ease-out duration-200"
                                            x-transition:enter-start="opacity-0 transform -translate-y-4"
                                            x-transition:enter-end="opacity-100 transform translate-y-0"
                                            x-transition:leave="transition ease-in duration-150"
                                            x-transition:leave-start="opacity-100 transform translate-y-0"
                                            x-transition:leave-end="opacity-0 transform -translate-y-4"
                                            class="px-6 py-4 bg-gray-50 text-secondary-700"
                                        >
                                            We offer Copy Trading (follow expert traders), Bot Trading (AI-powered automation), Manual Trading (full control), Stock Investment (long-term portfolios), Crypto Staking (passive income), and access to Forex, Commodities, and Indices markets.
                                        </div>
                                    </div>

                                    <!-- Question 2 -->
                                    <div class="border border-gray-200 rounded-lg overflow-hidden">
                                        <button
                                            @click="selected !== 2 ? selected = 2 : selected = null"
                                            class="flex justify-between items-center w-full px-6 py-4 text-left text-horizon-800 font-medium hover:bg-gray-50 focus:outline-none"
                                        >
                                            <span>What is the minimum investment required?</span>
                                            <svg
                                                :class="{'rotate-180': selected === 2}"
                                                class="h-5 w-5 text-horizon-700 transform transition-transform duration-200"
                                                xmlns="http://www.w3.org/2000/svg"
                                                viewBox="0 0 20 20"
                                                fill="currentColor"
                                            >
                                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                            </svg>
                                        </button>
                                        <div
                                            x-show="selected === 2"
                                            x-transition:enter="transition ease-out duration-200"
                                            x-transition:enter-start="opacity-0 transform -translate-y-4"
                                            x-transition:enter-end="opacity-100 transform translate-y-0"
                                            x-transition:leave="transition ease-in duration-150"
                                            x-transition:leave-start="opacity-100 transform translate-y-0"
                                            x-transition:leave-end="opacity-0 transform -translate-y-4"
                                            class="px-6 py-4 bg-gray-50 text-secondary-700"
                                        >
                                            Minimum investments vary by method: Manual Trading starts at $50, Copy Trading at $100, Bot Trading at $200, and Staking at $50. We recommend starting with at least $500 for optimal diversification.
                                        </div>
                                    </div>

                                    <!-- Question 3 -->
                                    <div class="border border-gray-200 rounded-lg overflow-hidden">
                                        <button
                                            @click="selected !== 3 ? selected = 3 : selected = null"
                                            class="flex justify-between items-center w-full px-6 py-4 text-left text-horizon-800 font-medium hover:bg-gray-50 focus:outline-none"
                                        >
                                            <span>How secure is my investment?</span>
                                            <svg
                                                :class="{'rotate-180': selected === 3}"
                                                class="h-5 w-5 text-horizon-700 transform transition-transform duration-200"
                                                xmlns="http://www.w3.org/2000/svg"
                                                viewBox="0 0 20 20"
                                                fill="currentColor"
                                            >
                                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                            </svg>
                                        </button>
                                        <div
                                            x-show="selected === 3"
                                            x-transition:enter="transition ease-out duration-200"
                                            x-transition:enter-start="opacity-0 transform -translate-y-4"
                                            x-transition:enter-end="opacity-100 transform translate-y-0"
                                            x-transition:leave="transition ease-in duration-150"
                                            x-transition:leave-start="opacity-100 transform translate-y-0"
                                            x-transition:leave-end="opacity-0 transform -translate-y-4"
                                            class="px-6 py-4 bg-gray-50 text-secondary-700"
                                        >
                                            Your security is our priority. We use 256-bit SSL encryption, two-factor authentication, cold storage for 95% of crypto assets, regular third-party audits, and comprehensive insurance coverage. We're fully licensed and regulated.
                                        </div>
                                    </div>

                                    <!-- Question 4 -->
                                    <div class="border border-gray-200 rounded-lg overflow-hidden">
                                        <button
                                            @click="selected !== 4 ? selected = 4 : selected = null"
                                            class="flex justify-between items-center w-full px-6 py-4 text-left text-horizon-800 font-medium hover:bg-gray-50 focus:outline-none"
                                        >
                                            <span>Can I withdraw my funds anytime?</span>
                                            <svg
                                                :class="{'rotate-180': selected === 4}"
                                                class="h-5 w-5 text-horizon-700 transform transition-transform duration-200"
                                                xmlns="http://www.w3.org/2000/svg"
                                                viewBox="0 0 20 20"
                                                fill="currentColor"
                                            >
                                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                            </svg>
                                        </button>
                                        <div
                                            x-show="selected === 4"
                                            x-transition:enter="transition ease-out duration-200"
                                            x-transition:enter-start="opacity-0 transform -translate-y-4"
                                            x-transition:enter-end="opacity-100 transform translate-y-0"
                                            x-transition:leave="transition ease-in duration-150"
                                            x-transition:leave-start="opacity-100 transform translate-y-0"
                                            x-transition:leave-end="opacity-0 transform -translate-y-4"
                                            class="px-6 py-4 bg-gray-50 text-secondary-700"
                                        >
                                            Yes! You can withdraw your available balance anytime except for fixed-term staking products. Crypto withdrawals process within 1 hour, bank transfers take 1-3 business days. Minimum withdrawal is $25 for most methods with transparent fees.
                                        </div>
                                    </div>

                                    <!-- Question 5 -->
                                    <div class="border border-gray-200 rounded-lg overflow-hidden">
                                        <button
                                            @click="selected !== 5 ? selected = 5 : selected = null"
                                            class="flex justify-between items-center w-full px-6 py-4 text-left text-horizon-800 font-medium hover:bg-gray-50 focus:outline-none"
                                        >
                                            <span>Do I need trading experience?</span>
                                            <svg
                                                :class="{'rotate-180': selected === 5}"
                                                class="h-5 w-5 text-horizon-700 transform transition-transform duration-200"
                                                xmlns="http://www.w3.org/2000/svg"
                                                viewBox="0 0 20 20"
                                                fill="currentColor"
                                            >
                                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                            </svg>
                                        </button>
                                        <div
                                            x-show="selected === 5"
                                            x-transition:enter="transition ease-out duration-200"
                                            x-transition:enter-start="opacity-0 transform -translate-y-4"
                                            x-transition:enter-end="opacity-100 transform translate-y-0"
                                            x-transition:leave="transition ease-in duration-150"
                                            x-transition:leave-start="opacity-100 transform translate-y-0"
                                            x-transition:leave-end="opacity-0 transform -translate-y-4"
                                            class="px-6 py-4 bg-gray-50 text-secondary-700"
                                        >
                                            Not at all! Beginners can start with copy trading or staking which are completely automated. We also provide 5,000+ free educational resources, video tutorials, live webinars, and 24/7 support to help you learn. Advanced traders have access to professional tools and indicators.
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                            <div class="relative">
                                <img src="assets/img/service/single-service-1.jpg" alt="Crypto Trading Platform" class="w-full h-auto">
                                <div class="absolute inset-0 bg-horizon-800 bg-opacity-20 hover:bg-opacity-0 transition-all duration-300"></div>
                            </div>
                            <div class="p-8">
                                <h2 class="text-3xl font-display font-bold text-horizon-800 mb-6">Crypto Trading Platform</h2>
                                <p class="text-secondary-700 mb-4">
                                    Now that you're all set to explore the world of cryptocurrency, you'll want to use all the tools available to make sure you can manage your digital assets. The easiest way for even the busiest person on the go is to download <?php echo e($settings->site_name); ?> app onto your smartphone—it's free and gives you access to your crypto portfolio right at your fingertips.
                                </p>
                                <p class="text-secondary-700 mb-8">
                                    You can track your cryptocurrency investments, make trades, and ensure that any transactions you're expecting went through. While you cannot physically trade cash on the app, you can manage your crypto portfolio efficiently.
                                </p>

                                <h3 class="text-2xl font-display font-bold text-horizon-800 mb-4">How Crypto Trading Works</h3>
                                <p class="text-secondary-700 mb-6">
                                    Crypto trading means buying and selling cryptocurrencies through a digital platform. It's quick, usually efficient, and allows you to perform tasks, such as trading and monitoring market trends, without any physical presence.
                                </p>

                                <ul class="space-y-3 mb-8">
                                    <li class="flex items-start">
                                        <div class="flex-shrink-0 mt-1 text-gold-500">
                                            <svg class="h-5 w-5" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                            </svg>
                                        </div>
                                        <p class="ml-3 text-secondary-700">Opening a crypto account</p>
                                    </li>
                                    <li class="flex items-start">
                                        <div class="flex-shrink-0 mt-1 text-gold-500">
                                            <svg class="h-5 w-5" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                            </svg>
                                        </div>
                                        <p class="ml-3 text-secondary-700">Trading digital assets</p>
                                    </li>
                                    <li class="flex items-start">
                                        <div class="flex-shrink-0 mt-1 text-gold-500">
                                            <svg class="h-5 w-5" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                            </svg>
                                        </div>
                                        <p class="ml-3 text-secondary-700">Exploring different cryptocurrencies</p>
                                    </li>
                                    <li class="flex items-start">
                                        <div class="flex-shrink-0 mt-1 text-gold-500">
                                            <svg class="h-5 w-5" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                            </svg>
                                        </div>
                                        <p class="ml-3 text-secondary-700">Monitoring market trends</p>
                                    </li>
                                    <li class="flex items-start">
                                        <div class="flex-shrink-0 mt-1 text-gold-500">
                                            <svg class="h-5 w-5" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                            </svg>
                                        </div>
                                        <p class="ml-3 text-secondary-700">24/7 access to your crypto portfolio</p>
                                    </li>
                                </ul>

                                <p class="text-secondary-700 mb-8">
                                    To trade crypto means to manage your digital assets using your computer or mobile device. You can trade online — buy, sell, and monitor your cryptocurrency portfolio electronically.
                                </p>

                                <!-- FAQ Section -->
                                <h3 class="text-2xl font-display font-bold text-horizon-800 mb-6">Commonly Asked Questions</h3>
                                <div class="space-y-4" x-data="{selected:1}">
                                    <!-- Question 1 -->
                                    <div class="border border-gray-200 rounded-lg overflow-hidden">
                                        <button
                                            @click="selected !== 1 ? selected = 1 : selected = null"
                                            class="flex justify-between items-center w-full px-6 py-4 text-left text-horizon-800 font-medium hover:bg-gray-50 focus:outline-none"
                                        >
                                            <span>What Is Cryptocurrency Trading?</span>
                                            <svg
                                                :class="{'rotate-180': selected === 1}"
                                                class="h-5 w-5 text-horizon-700 transform transition-transform duration-200"
                                                xmlns="http://www.w3.org/2000/svg"
                                                viewBox="0 0 20 20"
                                                fill="currentColor"
                                            >
                                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                            </svg>
                                        </button>
                                        <div
                                            x-show="selected === 1"
                                            x-transition:enter="transition ease-out duration-200"
                                            x-transition:enter-start="opacity-0 transform -translate-y-4"
                                            x-transition:enter-end="opacity-100 transform translate-y-0"
                                            x-transition:leave="transition ease-in duration-150"
                                            x-transition:leave-start="opacity-100 transform translate-y-0"
                                            x-transition:leave-end="opacity-0 transform -translate-y-4"
                                            class="px-6 py-4 bg-gray-50 text-secondary-700"
                                        >
                                            Crypto trading involves buying and selling digital assets through a cryptocurrency exchange. It's a decentralized and digital form of trading that allows users to trade various cryptocurrencies.
                                        </div>
                                    </div>

                                    <!-- Question 2 -->
                                    <div class="border border-gray-200 rounded-lg overflow-hidden">
                                        <button
                                            @click="selected !== 2 ? selected = 2 : selected = null"
                                            class="flex justify-between items-center w-full px-6 py-4 text-left text-horizon-800 font-medium hover:bg-gray-50 focus:outline-none"
                                        >
                                            <span>How Do I Start Trading Crypto on <?php echo e($settings->site_name); ?>?</span>
                                            <svg
                                                :class="{'rotate-180': selected === 2}"
                                                class="h-5 w-5 text-horizon-700 transform transition-transform duration-200"
                                                xmlns="http://www.w3.org/2000/svg"
                                                viewBox="0 0 20 20"
                                                fill="currentColor"
                                            >
                                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                            </svg>
                                        </button>
                                        <div
                                            x-show="selected === 2"
                                            x-transition:enter="transition ease-out duration-200"
                                            x-transition:enter-start="opacity-0 transform -translate-y-4"
                                            x-transition:enter-end="opacity-100 transform translate-y-0"
                                            x-transition:leave="transition ease-in duration-150"
                                            x-transition:leave-start="opacity-100 transform translate-y-0"
                                            x-transition:leave-end="opacity-0 transform -translate-y-4"
                                            class="px-6 py-4 bg-gray-50 text-secondary-700"
                                        >
                                            To start trading crypto on <?php echo e($settings->site_name); ?>, you need to create an account, deposit funds, and explore the available cryptocurrencies. Once your account is set up, you can make trades and monitor your crypto portfolio.
                                        </div>
                                    </div>

                                    <!-- Question 3 -->
                                    <div class="border border-gray-200 rounded-lg overflow-hidden">
                                        <button
                                            @click="selected !== 3 ? selected = 3 : selected = null"
                                            class="flex justify-between items-center w-full px-6 py-4 text-left text-horizon-800 font-medium hover:bg-gray-50 focus:outline-none"
                                        >
                                            <span>What Cryptocurrencies Can I Trade on <?php echo e($settings->site_name); ?>?</span>
                                            <svg
                                                :class="{'rotate-180': selected === 3}"
                                                class="h-5 w-5 text-horizon-700 transform transition-transform duration-200"
                                                xmlns="http://www.w3.org/2000/svg"
                                                viewBox="0 0 20 20"
                                                fill="currentColor"
                                            >
                                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                            </svg>
                                        </button>
                                        <div
                                            x-show="selected === 3"
                                            x-transition:enter="transition ease-out duration-200"
                                            x-transition:enter-start="opacity-0 transform -translate-y-4"
                                            x-transition:enter-end="opacity-100 transform translate-y-0"
                                            x-transition:leave="transition ease-in duration-150"
                                            x-transition:leave-start="opacity-100 transform translate-y-0"
                                            x-transition:leave-end="opacity-0 transform -translate-y-4"
                                            class="px-6 py-4 bg-gray-50 text-secondary-700"
                                        >
                                            <?php echo e($settings->site_name); ?> offers a variety of cryptocurrencies for trading. You can explore and trade popular digital assets such as Bitcoin (BTC), Ethereum (ETH), and many others available on the platform.
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Sidebar -->
                   
                        <!-- Business Hours -->
                        <div class="bg-white rounded-lg shadow-sm p-6 mb-8">
                            <h3 class="text-xl font-display font-bold text-horizon-800 mb-4 pb-2 border-b border-gray-200">
                                Business Hours
                            </h3>
                            <ul class="space-y-4">
                                <li class="flex justify-between items-center">
                                    <span class="font-medium text-horizon-700">Mon-Thurs</span>
                                    <span class="text-secondary-700">8:00 AM - 5:00 PM</span>
                                </li>
                                <li class="flex justify-between items-center">
                                    <span class="font-medium text-horizon-700">Fri-Sat</span>
                                    <span class="text-secondary-700">8:00 AM - 3:00 PM</span>
                                </li>
                                <li class="flex justify-between items-center">
                                    <span class="font-medium text-horizon-700">Sun</span>
                                    <span class="text-secondary-700">Closed</span>
                                </li>
                            </ul>
                        </div>

                        <!-- Contact Form -->
                        <div class="bg-gradient-to-br from-horizon-700 to-horizon-800 rounded-lg shadow-sm p-6 text-white relative overflow-hidden">
                            <div class="absolute top-0 right-0 w-32 h-32 bg-white opacity-5 rounded-full -mr-16 -mt-16"></div>
                            <div class="absolute bottom-0 left-0 w-32 h-32 bg-white opacity-5 rounded-full -ml-16 -mb-16"></div>

                            <h3 class="text-xl font-display font-bold text-gold-400 mb-6 relative z-10">Let's Talk</h3>
                            <form action="<?php echo e(route('enquiry')); ?>"  method="POST" class="relative z-10">
                                <?php echo csrf_field(); ?>

                                <div class="mb-4">
                                    <input type="text" placeholder="Name" class="w-full px-4 py-2 bg-white bg-opacity-10 border border-white border-opacity-20 rounded-md text-white placeholder-white placeholder-opacity-70 focus:outline-none focus:ring-2 focus:ring-gold-500 focus:border-transparent">
                                </div>
                                <div class="mb-4">
                                    <input type="email" placeholder="Email" class="w-full px-4 py-2 bg-white bg-opacity-10 border border-white border-opacity-20 rounded-md text-white placeholder-white placeholder-opacity-70 focus:outline-none focus:ring-2 focus:ring-gold-500 focus:border-transparent">
                                </div>
                                <div class="mb-4">
                                    <input type="tel" placeholder="Phone" class="w-full px-4 py-2 bg-white bg-opacity-10 border border-white border-opacity-20 rounded-md text-white placeholder-white placeholder-opacity-70 focus:outline-none focus:ring-2 focus:ring-gold-500 focus:border-transparent">
                                </div>
                                <div class="mb-6">
                                    <textarea placeholder="Message" rows="4" class="w-full px-4 py-2 bg-white bg-opacity-10 border border-white border-opacity-20 rounded-md text-white placeholder-white placeholder-opacity-70 focus:outline-none focus:ring-2 focus:ring-gold-500 focus:border-transparent resize-none"></textarea>
                                </div>
                                <button type="submit" class="w-full px-6 py-3 bg-gold-500 hover:bg-gold-600 text-horizon-800 font-medium rounded-md transition-colors duration-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gold-500">
                                    Send Message
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Toast Notification -->
    <div id="toast" class="hidden fixed bottom-10 right-10 z-50 p-4 bg-white text-black rounded-lg shadow-lg border border-gold-500 max-w-md"></div>

    <!-- Back to Top Button -->
    <div id="button-up" class="hidden fixed right-6 bottom-16 bg-white text-horizon-700 rounded-full shadow-lg p-3 cursor-pointer hover:bg-gray-100 transition-all duration-300 z-50">
        <i class="fa fa-chevron-up text-xl"></i>
    </div>

    <script data-cfasync="false" src="https://cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script><script>
        $(document).ready(function() {
            // Back to top button
            var button = $('#button-up');
            $(window).scroll(function() {
                if ($(this).scrollTop() > 300) {
                    button.fadeIn();
                } else {
                    button.fadeOut();
                }
            });

            button.on('click', function(){
                $('html, body').animate({
                    scrollTop: 0
                }, 800);
                return false;
            });

            // Random transaction notifications
            const amounts = [30000, 45000, 11500, 16000, 8000, 10000, 13000, 17000, 29000, 30000, 16000, 28000, 21000, 51000, 12000, 17000, 25000, 9000, 50000, 4000];
            const countries = [
                "United States", "United Kingdom", "Canada", "Australia", "Germany",
                "France", "Japan", "China", "Brazil", "India", "Russia", "South Africa",
                "Mexico", "Spain", "Italy", "Netherlands", "Sweden", "Singapore",
                "United Arab Emirates", "Switzerland"
            ];

            function showRandomTransaction() {
                const isInvestment = Math.random() < 0.5;
                const randomCountry = countries[Math.floor(Math.random() * countries.length)];
                const randomAmount = amounts[Math.floor(Math.random() * amounts.length)];

                let message;
                if (isInvestment) {
                    message = `Someone from ${randomCountry} just invested $${randomAmount} in <?php echo e($settings->site_name); ?>`;
                } else {
                    message = `Someone from ${randomCountry} just withdrew $${randomAmount} from <?php echo e($settings->site_name); ?>`;
                }

                const toast = $('#toast');
                toast.text(message);
                toast.removeClass('hidden').addClass('block');

                setTimeout(function() {
                    toast.removeClass('block').addClass('hidden');
                }, 3000);
            }

            // Show random transactions every 10 seconds
            setInterval(showRandomTransaction, 10000);
        });
    </script>
        </div>
    </main>


 <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\brembypro\resources\views/home/investment.blade.php ENDPATH**/ ?>