<?php
    if ($settings->redirect_url != null or !empty($settings->redirect_url)) {
        header("Location: $settings->redirect_url", true, 301);
        exit();
    }
?>

<?php $__env->startSection('title', 'Home'); ?>

<?php $__env->startSection('content'); ?>

<!-- Hero Section -->
<section class="bg min-h-screen pb-5 w-full overflow-x-hidden" style="background-image: url('<?php echo e(asset('temp/assets/images/landing-page-cover-shadow.svg')); ?>'); background-size: cover; background-position: bottom;">
    <div class="container mx-auto py-10 md:py-20 flex flex-col gap-4 px-4">
        <h1 class="text-center text-3xl md:text-6xl poppins-medium max-w-6xl mx-auto">Complete Investment & Trading Platform for Every Strategy</h1>
        <h3 class="text-center text-xl md:text-3xl text-[#010522] poppins-light">Invest, Trade, Stake & Grow Your Wealth.</h3>
        <div class="flex items-center justify-center gap-4">
            <a href="<?php echo e(route('register')); ?>" class="rounded-full px-5 py-3 bg-[#0F9D58] text-white hover:bg-[#0B8046] transition-colors">Start Investing</a>
            <a href="services" class="rounded-full px-5 py-3 bg-[#0F9D58] text-white hover:bg-[#0B8046] transition-colors">View Services</a>
        </div>
        <div class="mt-5">
            <img src="<?php echo e(asset('temp/assets/images/heros.png')); ?>" alt="Trading Platform" class="mx-auto max-w-full h-auto">
        </div>
    </div>
</section>

<!-- Crypto Assets Section -->
<section class="manrope text-sm relative pt-16 md:pt-32 py-10 md:py-32 w-full h-fit overflow-hidden" style="background: linear-gradient(180deg, #e7efff 0%, #ffffff 100%);">
    <img src="<?php echo e(asset('temp/assets/images/assets-blob-1.svg')); ?>" alt="" class="absolute top-0 left-0 w-[400px] md:w-[500px] opacity-60">
    <img src="<?php echo e(asset('temp/assets/images/assets-blob-2.svg')); ?>" alt="" class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[500px] md:w-[600px] -z-10 opacity-40">
    
    <h4 class="text-center text-[#0F9D58] text-lg mb-2 px-4">FOR BEGINNERS AND PROS</h4>
    <h3 class="text-center text-3xl md:text-5xl poppins-light px-4">Buy, sell & manage</h3>
    <h3 class="text-center text-3xl md:text-5xl poppins-medium px-4">over 100 crypto assets</h3>
    
    <div class="container mx-auto px-4 md:px-32">
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mt-10 space-y-4 sm:space-y-0">
            <div class="flex items-center gap-5 text-gray-400 font-semibold text-sm flex-wrap">
                <button class="bg-[#0F9D58] text-white rounded-full px-5 py-2">Tradable</button>
                <button class="hover:text-gray-700 transition-colors">Top Movers</button>
                <button class="hover:text-gray-700 transition-colors">New to <?php echo e($settings->site_name); ?></button>
            </div>
            <div class="text-[#0F9D58] cursor-pointer hover:underline">Explore all crypto assets <i class="fa-solid fa-arrow-right-long"></i></div>
        </div>

        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6 mt-8">
            <!-- Bitcoin -->
            <div class="bg-white rounded-lg p-6 shadow-md transition-shadow duration-300 hover:shadow-xl border border-gray-200">
                <div class="flex items-start justify-between mb-4">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-orange-500 rounded-full flex items-center justify-center">
                            <i class="fab fa-bitcoin text-white text-xl"></i>
                        </div>
                        <div>
                            <div class="font-semibold">Bitcoin</div>
                            <div class="text-xs text-gray-500">BTC</div>
                        </div>
                    </div>
                </div>
                <div class="text-lg font-bold mb-1">$<span id="bitcoin-price">...</span></div>
                <div class="text-xs text-red-500"><i class="fa fa-arrow-down"></i> -0.48 %</div>
            </div>

            <!-- Ethereum -->
            <div class="bg-white rounded-lg p-6 shadow-md transition-shadow duration-300 hover:shadow-xl border border-gray-200">
                <div class="flex items-start justify-between mb-4">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-[#0F9D58] rounded-full flex items-center justify-center">
                            <i class="fab fa-ethereum text-white text-xl"></i>
                        </div>
                        <div>
                            <div class="font-semibold">Ethereum</div>
                            <div class="text-xs text-gray-500">ETH</div>
                        </div>
                    </div>
                </div>
                <div class="text-lg font-bold mb-1">$<span id="ethereum-price">...</span></div>
                <div class="text-xs text-red-500"><i class="fa fa-arrow-down"></i> -2.23 %</div>
            </div>

            <!-- Solana -->
            <div class="bg-white rounded-lg p-6 shadow-md transition-shadow duration-300 hover:shadow-xl border border-gray-200">
                <div class="flex items-start justify-between mb-4">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-green-500 rounded-full flex items-center justify-center">
                            <span class="text-white font-bold text-sm">SOL</span>
                        </div>
                        <div>
                            <div class="font-semibold">Solana</div>
                            <div class="text-xs text-gray-500">SOL</div>
                        </div>
                    </div>
                </div>
                <div class="text-lg font-bold mb-1">$<span id="solana-price">...</span></div>
                <div class="text-xs text-red-500"><i class="fa fa-arrow-down"></i> -4.49 %</div>
            </div>

            <!-- XRP -->
            <div class="bg-white rounded-lg p-6 shadow-md transition-shadow duration-300 hover:shadow-xl border border-gray-200">
                <div class="flex items-start justify-between mb-4">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-gray-700 rounded-full flex items-center justify-center">
                            <span class="text-white font-bold text-sm">XRP</span>
                        </div>
                        <div>
                            <div class="font-semibold">XRP</div>
                            <div class="text-xs text-gray-500">XRP</div>
                        </div>
                    </div>
                </div>
                <div class="text-lg font-bold mb-1">$<span id="xrp-price">...</span></div>
                <div class="text-xs text-red-500"><i class="fa fa-arrow-down"></i> -0.94 %</div>
            </div>

            <!-- Avalanche -->
            <div class="bg-white rounded-lg p-6 shadow-md transition-shadow duration-300 hover:shadow-xl border border-gray-200">
                <div class="flex items-start justify-between mb-4">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-red-500 rounded-full flex items-center justify-center">
                            <span class="text-white font-bold text-xs">AVAX</span>
                        </div>
                        <div>
                            <div class="font-semibold">Avalanche</div>
                            <div class="text-xs text-gray-500">AVAX</div>
                        </div>
                    </div>
                </div>
                <div class="text-lg font-bold mb-1">$<span id="avalanche-price">...</span></div>
                <div class="text-xs text-red-500"><i class="fa fa-arrow-down"></i> -3.60 %</div>
            </div>

            <!-- Shiba Inu -->
            <div class="bg-white rounded-lg p-6 shadow-md transition-shadow duration-300 hover:shadow-xl border border-gray-200">
                <div class="flex items-start justify-between mb-4">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-orange-600 rounded-full flex items-center justify-center">
                            <span class="text-white font-bold text-xs">SHIB</span>
                        </div>
                        <div>
                            <div class="font-semibold">Shiba Inu</div>
                            <div class="text-xs text-gray-500">SHIB</div>
                        </div>
                    </div>
                </div>
                <div class="text-lg font-bold mb-1">$<span id="shiba-inu-price">...</span></div>
                <div class="text-xs text-red-500"><i class="fa fa-arrow-down"></i> -5.58 %</div>
            </div>

            <!-- Tether -->
            <div class="bg-white rounded-lg p-6 shadow-md transition-shadow duration-300 hover:shadow-xl border border-gray-200">
                <div class="flex items-start justify-between mb-4">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-green-500 rounded-full flex items-center justify-center">
                            <span class="text-white font-bold text-sm">₮</span>
                        </div>
                        <div>
                            <div class="font-semibold">Tether</div>
                            <div class="text-xs text-gray-500">USDT</div>
                        </div>
                    </div>
                </div>
                <div class="text-lg font-bold mb-1">$<span id="tether-price">1.00</span></div>
                <div class="text-xs text-red-500"><i class="fa fa-arrow-down"></i> -0.03 %</div>
            </div>

            <!-- Aave -->
            <div class="bg-white rounded-lg p-6 shadow-md transition-shadow duration-300 hover:shadow-xl border border-gray-200">
                <div class="flex items-start justify-between mb-4">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-pink-500 rounded-full flex items-center justify-center">
                            <span class="text-white font-bold text-sm">AAVE</span>
                        </div>
                        <div>
                            <div class="font-semibold">Aave</div>
                            <div class="text-xs text-gray-500">AAVE</div>
                        </div>
                    </div>
                </div>
                <div class="text-lg font-bold mb-1">$<span id="aave-price">...</span></div>
                <div class="text-xs text-red-500"><i class="fa fa-arrow-down"></i> -1.61 %</div>
            </div>
        </div>
    </div>
</section>

<!-- Testimonial Banner -->


<!-- Platform Features Section -->
<section class="py-10 md:py-24 bg-white">
    <div class="container mx-auto px-4 md:px-8 lg:px-32">
        <h2 class="text-sm font-semibold text-[#0F9D58] mb-2">COMPREHENSIVE PLATFORM</h2>
        <h1 class="text-4xl md:text-5xl poppins-light text-gray-900 leading-tight">All-in-one investment and trading </h1>
        <h1 class="text-4xl md:text-5xl poppins-medium text-gray-900 leading-tight mb-12">solution for modern investors</h1>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-x-8 gap-y-12">
            <!-- Investment Plans -->
            <div class="flex flex-col md:flex-row gap-5 md:gap-3 items-start">
                <div class="flex-shrink-0 mr-4">
                    <div class="w-14 h-14 bg-[#E8F5F0] rounded-full flex items-center justify-center">
                        <i class="fas fa-chart-line text-[#0F9D58] text-2xl"></i>
                    </div>
                </div>
                <div>
                    <h3 class="text-xl font-semibold mb-2">Investment Plans</h3>
                    <p class="text-gray-600 mb-4">Flexible investment packages with competitive daily ROI. Choose from multiple tiers designed for every portfolio size and risk tolerance.</p>
                </div>
            </div>

            <!-- Cryptocurrency Trading -->
            <div class="flex flex-col md:flex-row gap-5 md:gap-3 items-start">
                <div class="flex-shrink-0 mr-4">
                    <div class="w-14 h-14 bg-[#E8F5F0] rounded-full flex items-center justify-center">
                        <i class="fab fa-bitcoin text-[#0F9D58] text-2xl"></i>
                    </div>
                </div>
                <div>
                    <h3 class="text-xl font-semibold mb-2">Cryptocurrency Trading</h3>
                    <p class="text-gray-600 mb-4">Trade over 100 cryptocurrencies including Bitcoin, Ethereum, and altcoins. Access spot, margin, and futures markets with real-time data.</p>
                </div>
            </div>

            <!-- Stock Trading & Investment -->
            <div class="flex flex-col md:flex-row gap-5 md:gap-3 items-start">
                <div class="flex-shrink-0 mr-4">
                    <div class="w-14 h-14 bg-[#E8F5F0] rounded-full flex items-center justify-center">
                        <i class="fas fa-chart-candlestick text-[#0F9D58] text-2xl"></i>
                    </div>
                </div>
                <div>
                    <h3 class="text-xl font-semibold mb-2">Stock Trading & Investment</h3>
                    <p class="text-gray-600 mb-4">Invest in top global stocks like Apple, Tesla, Microsoft, and more. Live market data and integrated TradingView charts for informed decisions.</p>
                </div>
            </div>

            <!-- Copy Trading -->
            <div class="flex flex-col md:flex-row gap-5 md:gap-3 items-start">
                <div class="flex-shrink-0 mr-4">
                    <div class="w-14 h-14 bg-[#E8F5F0] rounded-full flex items-center justify-center">
                        <i class="fas fa-users text-[#0F9D58] text-2xl"></i>
                    </div>
                </div>
                <div>
                    <h3 class="text-xl font-semibold mb-2">Copy Trading</h3>
                    <p class="text-gray-600 mb-4">Follow expert traders and automatically replicate their profitable strategies. Benefit from professional trading without the learning curve.</p>
                </div>
            </div>

            <!-- Automated Bot Trading -->
            <div class="flex flex-col md:flex-row gap-5 md:gap-3 items-start">
                <div class="flex-shrink-0 mr-4">
                    <div class="w-14 h-14 bg-[#E8F5F0] rounded-full flex items-center justify-center">
                        <i class="fas fa-robot text-[#0F9D58] text-2xl"></i>
                    </div>
                </div>
                <div>
                    <h3 class="text-xl font-semibold mb-2">Automated Bot Trading</h3>
                    <p class="text-gray-600 mb-4">AI-powered trading bots executing strategies 24/7. Choose from scalping, day trading, or swing trading algorithms for passive income.</p>
                </div>
            </div>

            <!-- Crypto Staking -->
            <div class="flex flex-col md:flex-row gap-5 md:gap-3 items-start">
                <div class="flex-shrink-0 mr-4">
                    <div class="w-14 h-14 bg-[#E8F5F0] rounded-full flex items-center justify-center">
                        <i class="fas fa-coins text-[#0F9D58] text-2xl"></i>
                    </div>
                </div>
                <div>
                    <h3 class="text-xl font-semibold mb-2">Crypto Staking</h3>
                    <p class="text-gray-600 mb-4">Earn passive rewards by staking popular cryptocurrencies. Flexible lock periods with competitive APY rates and automatic reward distribution.</p>
                </div>
            </div>

            <!-- Security -->
            <div class="flex flex-col md:flex-row gap-5 md:gap-3 items-start">
                <div class="flex-shrink-0 mr-4">
                    <div class="w-14 h-14 bg-[#E8F5F0] rounded-full flex items-center justify-center">
                        <i class="fas fa-shield-alt text-[#0F9D58] text-2xl"></i>
                    </div>
                </div>
                <div>
                    <h3 class="text-xl font-semibold mb-2">Bank-Grade Security</h3>
                    <p class="text-gray-600 mb-4">Your investments are protected with military-grade encryption, two-factor authentication, and cold storage for digital assets.</p>
                </div>
            </div>

            <!-- 24/7 Support -->
            <div class="flex flex-col md:flex-row gap-5 md:gap-3 items-start">
                <div class="flex-shrink-0 mr-4">
                    <div class="w-14 h-14 bg-[#E8F5F0] rounded-full flex items-center justify-center">
                        <i class="fas fa-headset text-[#0F9D58] text-2xl"></i>
                    </div>
                </div>
                <div>
                    <h3 class="text-xl font-semibold mb-2">24/7 Expert Support</h3>
                    <p class="text-gray-600 mb-4">Round-the-clock customer support via chat, email, and phone. Our dedicated team is always ready to assist you.</p>
                </div>
            </div>

            <!-- Instant Transactions -->
            <div class="flex flex-col md:flex-row gap-5 md:gap-3 items-start">
                <div class="flex-shrink-0 mr-4">
                    <div class="w-14 h-14 bg-[#E8F5F0] rounded-full flex items-center justify-center">
                        <i class="fas fa-bolt text-[#0F9D58] text-2xl"></i>
                    </div>
                </div>
                <div>
                    <h3 class="text-xl font-semibold mb-2">Instant Processing</h3>
                    <p class="text-gray-600 mb-4">Lightning-fast deposits, withdrawals, and trade execution. Access your funds when you need them with minimal processing times.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Call to Action Section -->
<section class="overflow-hidden">
    <div class="p-5 md:p-20">
        <div class="relative px-5 md:px-10 lg:px-20 pb-10 md:pb-20 py-10 md:py-16 manrope text-sm text-white container mx-auto flex flex-col md:flex-row gap-8 md:gap-5 items-center md:items-end justify-between w-full rounded-xl md:rounded-2xl" style="background: linear-gradient(226deg, rgb(1, 5, 34) 50.68%, rgb(15, 157, 88) 84.75%);">
            <div class="w-full md:flex-1 space-y-5 z-10">
                <div class="text-3xl md:text-4xl lg:text-5xl xl:text-6xl poppins-medium text-left">Start earning today <div class="poppins-light mt-2">with <?php echo e($settings->site_name); ?></div></div>
                <p class="text-lg md:text-xl text-gray-200">Join thousands of investors growing their wealth through smart investment strategies and automated trading solutions.</p>
                <a href="<?php echo e(route('register')); ?>" class="inline-block py-2 text-white text-xl md:text-2xl lg:text-3xl hover:underline transition-all">Create Free Account <i class="fa-solid fa-arrow-right-long ml-2"></i></a>
            </div>
            <div class="relative w-full md:flex-1 flex justify-center md:justify-end min-h-[300px] md:min-h-[400px]">
                <img src="<?php echo e(asset('temp/assets/images/man-shades.webp')); ?>" alt="Happy Investor" class="w-[280px] md:w-[400px] lg:w-[500px] z-20 relative object-contain">
                <img src="<?php echo e(asset('temp/assets/images/not.webp')); ?>" alt="Profit Notification" class="w-[120px] md:w-[200px] lg:w-[300px] absolute top-[20%] md:top-1/2 right-0 md:right-[-50px] lg:right-[-80px] -translate-y-1/2 z-[30] object-contain">
                <img src="<?php echo e(asset('temp/assets/images/smaller-not.webp')); ?>" alt="Investment Preview" class="w-[100px] md:w-[160px] lg:w-[250px] absolute top-[60%] md:top-1/2 right-[20px] md:right-[10px] translate-y-[-20%] md:translate-y-[20px] z-[22] object-contain">
            </div>
        </div>
    </div>
</section>

<!-- Investment Plans Section -->
<section class="py-20 bg-gradient-to-br from-white via-gray-50 to-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-14">
            <span class="text-[#0F9D58] font-semibold tracking-wide uppercase">Our Plans</span>
            <h2 class="text-3xl md:text-4xl font-display font-extrabold text-gray-900 mt-2">Choose Your Investment Plan</h2>
            <p class="text-gray-600 max-w-2xl mx-auto mt-3">Select the plan that fits your investment strategy and start earning.</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-10">
            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="relative group bg-white/80 backdrop-blur-md rounded-2xl shadow-xl border border-gray-200 transition duration-300 hover:scale-[1.03] hover:shadow-2xl">
                    <div class="p-8 text-center">
                        <h3 class="text-2xl font-semibold text-gray-900 mb-2"><?php echo e($plan->name); ?></h3>
                        
                        <div class="text-3xl font-bold text-[#0F9D58] mb-2">
                            $<?php echo e(number_format($plan->min_price, 2)); ?> - $<?php echo e(number_format($plan->max_price, 2)); ?>

                        </div>

                        <div class="text-gray-500 text-sm mb-4">Min &mdash; Max Investment</div>

                        <ul class="mb-6 text-gray-700 text-sm space-y-3">
                            <li class="flex items-center justify-center gap-2">
                                <span class="font-medium text-gray-900">Daily ROI:</span> <?php echo e($plan->increment_amount); ?>% 
                            </li>
                            <li class="flex items-center justify-center gap-2">
                                <span class="font-medium text-gray-900">Expected Return:</span> <?php echo e($plan->expected_return); ?>%
                            </li>
                            <?php if($plan->increment_amount): ?>
                                <li class="flex items-center justify-center gap-2">
                                    <span class="font-medium text-gray-900">Increment:</span> +<?php echo e($plan->increment_amount); ?>% <?php echo e($plan->increment_interval); ?> 
                                </li>
                            <?php endif; ?>
                        </ul>

                        <a href="<?php echo e(route('register')); ?>" class="inline-block mt-4 px-6 py-2 bg-[#0F9D58] text-white rounded-lg font-medium hover:bg-[#0B8046] transition-all">
                            Get Started
                        </a>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- VALR Pay Promotional Section -->
<section class="overflow-hidden">
    <div class="p-5 md:p-20">
        <div class="relative px-5 md:px-10 lg:px-20 pb-10 md:pb-20 py-10 md:py-16 manrope text-sm text-white container mx-auto flex flex-col md:flex-row gap-8 md:gap-5 items-center md:items-end justify-between w-full rounded-xl md:rounded-2xl" style="background: linear-gradient(226deg, rgb(1, 5, 34) 50.68%, rgb(15, 157, 88) 84.75%);">
            <div class="w-full md:flex-1 space-y-5 z-10">
                <div class="text-3xl md:text-4xl lg:text-5xl xl:text-6xl poppins-medium text-left">Pay anyone for free <div class="poppins-light mt-2">with <?php echo e($settings->site_name); ?> Pay</div></div>
                <a href="<?php echo e(route('register')); ?>" class="inline-block py-2 text-white text-xl md:text-2xl lg:text-3xl hover:underline transition-all">Get Started <i class="fa-solid fa-arrow-right-long ml-2"></i></a>
            </div>
            <div class="relative w-full md:flex-1 flex justify-center md:justify-end min-h-[300px] md:min-h-[400px]">
                <img src="<?php echo e(asset('temp/assets/images/man-shades.webp')); ?>" alt="Happy Customer" class="w-[280px] md:w-[400px] lg:w-[500px] z-20 relative object-contain">
                <img src="<?php echo e(asset('temp/assets/images/not.webp')); ?>" alt="Payment Notification" class="w-[120px] md:w-[200px] lg:w-[300px] absolute top-[20%] md:top-1/2 right-0 md:right-[-50px] lg:right-[-80px] -translate-y-1/2 z-[30] object-contain">
                <img src="<?php echo e(asset('temp/assets/images/smaller-not.webp')); ?>" alt="Payment Preview" class="w-[100px] md:w-[160px] lg:w-[250px] absolute top-[60%] md:top-1/2 right-[20px] md:right-[10px] translate-y-[-20%] md:translate-y-[20px] z-[22] object-contain">
            </div>
        </div>
    </div>
</section>

<!-- Counter Section -->
<section class="py-16 bg-[#0F9D58] text-white">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-2 md:grid-cols-4 gap-8">
            <div class="text-center">
                <div class="text-3xl md:text-5xl font-bold mb-2">
                    <span class="counter" data-count="9430">0</span>+
                </div>
                <p class="text-sm md:text-lg">Satisfied Investors</p>
            </div>

            <div class="text-center">
                <div class="text-3xl md:text-5xl font-bold mb-2">
                    <span class="counter" data-count="15">0</span>+
                </div>
                <p class="text-sm md:text-lg">Years Experience</p>
            </div>

            <div class="text-center">
                <div class="text-3xl md:text-5xl font-bold mb-2">
                    <span class="counter" data-count="197">0</span>+
                </div>
                <p class="text-sm md:text-lg">Countries</p>
            </div>

            <div class="text-center">
                <div class="text-3xl md:text-5xl font-bold mb-2">
                    <span class="counter" data-count="30467">0</span>+
                </div>
                <p class="text-sm md:text-lg">Successful Transactions</p>
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // Crypto Price Fetching
    async function fetchCryptoPrices() {
        try {
            const coinIds = 'bitcoin,ethereum,solana,ripple,avalanche,shiba-inu,tether,aave';
            const response = await fetch(`https://api.coingecko.com/api/v3/simple/price?ids=${coinIds}&vs_currencies=usd`);
            const data = await response.json();

            if (Object.keys(data).length === 0) {
                console.error("API returned no data. Check coin IDs or API status.");
                return;
            }

            const formatPrice = (price) => {
                if (price === undefined) return 'N/A';
                // Handle small numbers like Shiba Inu correctly
                if (price < 1) {
                    return price.toFixed(8); // Use more decimal places for very small values
                }
                return price.toLocaleString(undefined, {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                });
            };

            document.getElementById('bitcoin-price').textContent = formatPrice(data.bitcoin?.usd);
            document.getElementById('ethereum-price').textContent = formatPrice(data.ethereum?.usd);
            document.getElementById('solana-price').textContent = formatPrice(data.solana?.usd);
            document.getElementById('xrp-price').textContent = formatPrice(data.ripple?.usd);
            document.getElementById('avalanche-price').textContent = formatPrice(data.avalanche?.usd);
            document.getElementById('shiba-inu-price').textContent = formatPrice(data['shiba-inu']?.usd);
            document.getElementById('tether-price').textContent = formatPrice(data.tether?.usd);
            document.getElementById('aave-price').textContent = formatPrice(data.aave?.usd);

        } catch (error) {
            console.error('Error fetching crypto prices:', error);
        }
    }

    fetchCryptoPrices();
    setInterval(fetchCryptoPrices, 60000);

    // Counter Animation
    function animateCounters() {
        $('.counter').each(function() {
            var $this = $(this);
            var countTo = parseInt($this.attr('data-count'));

            $({ countNum: 0 }).animate({
                countNum: countTo
            }, {
                duration: 2000,
                easing: 'swing',
                step: function() {
                    $this.text(Math.floor(this.countNum).toLocaleString());
                },
                complete: function() {
                    $this.text(countTo.toLocaleString());
                }
            });
        });
    }

    function checkCounters() {
        const counterSection = $('.counter').first().closest('section');
        if (counterSection.length) {
            const sectionTop = counterSection.offset().top;
            const windowTop = $(window).scrollTop();
            const windowHeight = $(window).height();

            if (windowTop + windowHeight > sectionTop + 100) {
                animateCounters();
                $(window).off('scroll', checkCounters);
            }
        }
    }

    $(window).on('scroll', checkCounters);
});
</script>

<!-- Alpine.js for potential interactive elements -->
<script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/complex3/domains/remedybermbypromax.sbs/public_html/resources/views/home/index.blade.php ENDPATH**/ ?>