<?php $__env->startSection('title', 'Investment Plans'); ?>

<?php $content = app('App\Http\Controllers\FrontController'); ?>
<?php $__env->startSection('content'); ?>

<!-- Hero Section -->
<section class="bg min-h-screen pb-5 w-full overflow-x-hidden" style="background-image: url('<?php echo e(asset('temp/assets/images/landing-page-cover-shadow.svg')); ?>'); background-size: cover; background-position: bottom;">
    <div class="container mx-auto py-10 md:py-20 flex flex-col gap-4 px-4">
        <h1 class="text-center text-3xl md:text-6xl poppins-medium max-w-6xl mx-auto">Complete Investment & Trading Ecosystem for Modern Investors</h1>
        <h3 class="text-center text-xl md:text-3xl text-[#010522] poppins-light">Investment Plans • Copy Trading • Bot Trading • Stock Trading • Crypto Trading • Staking</h3>
        <div class="flex items-center justify-center gap-4">
            <a href="<?php echo e(route('register')); ?>" class="rounded-full px-5 py-3 bg-[#0F9D58] text-white hover:bg-[#0B8046] transition-colors">Start Investing</a>
            <a href="<?php echo e(url('about')); ?>" class="rounded-full px-5 py-3 bg-[#0F9D58] text-white hover:bg-[#0B8046] transition-colors">Explore Features</a>
        </div>
        <div class="mt-5">
            <img src="<?php echo e(asset('temp/assets/images/heros.png')); ?>" alt="Investment Platform" class="mx-auto max-w-full h-auto">
        </div>
    </div>
</section>

<!-- Investment Features Section -->
<section class="manrope text-sm relative py-10 md:py-24 w-full h-fit overflow-hidden" style="background: linear-gradient(180deg, #e8f5f0 0%, #ffffff 100%);">
    <img src="<?php echo e(asset('temp/assets/images/assets-blob-1.svg')); ?>" alt="" class="absolute top-0 left-0 w-[400px] md:w-[500px] opacity-30">
    <img src="<?php echo e(asset('temp/assets/images/assets-blob-2.svg')); ?>" alt="" class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[500px] md:w-[600px] -z-10 opacity-20">
    
    <div class="container mx-auto px-4 md:px-8 lg:px-32 relative z-10">
        <h2 class="text-sm font-semibold text-[#0F9D58] mb-2">ALL-IN-ONE PLATFORM</h2>
        <h1 class="text-4xl md:text-5xl poppins-light text-gray-900 leading-tight">Seven powerful ways to</h1>
        <h1 class="text-4xl md:text-5xl poppins-medium text-gray-900 leading-tight mb-12">grow your wealth</h1>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-x-8 gap-y-12">
            <!-- Investment Plans -->
            <div class="flex flex-col md:flex-row gap-5 md:gap-3 items-start">
                <div class="flex-shrink-0 mr-4">
                    <div class="w-14 h-14 bg-[#E8F5F0] rounded-full flex items-center justify-center">
                        <i class="fas fa-chart-line text-[#0F9D58] text-2xl"></i>
                    </div>
                </div>
                <div>
                    <h3 class="text-xl font-semibold mb-2">Investment Plans</h3>
                    <p class="text-gray-600 mb-4">Flexible plans with daily/weekly ROI distribution. Choose from starter to premium tiers with automated profit calculations and instant withdrawals.</p>
                </div>
            </div>

            <!-- Copy Trading -->
            <div class="flex flex-col md:flex-row gap-5 md:gap-3 items-start">
                <div class="flex-shrink-0 mr-4">
                    <div class="w-14 h-14 bg-[#E8F5F0] rounded-full flex items-center justify-center">
                        <i class="fas fa-users text-[#0F9D58] text-2xl"></i>
                    </div>
                </div>
                <div>
                    <h3 class="text-xl font-semibold mb-2">Copy Trading</h3>
                    <p class="text-gray-600 mb-4">Follow expert traders and automatically replicate their strategies. Track performance, win rates, and ROI before subscribing to top performers.</p>
                </div>
            </div>

            <!-- Bot Trading -->
            <div class="flex flex-col md:flex-row gap-5 md:gap-3 items-start">
                <div class="flex-shrink-0 mr-4">
                    <div class="w-14 h-14 bg-[#E8F5F0] rounded-full flex items-center justify-center">
                        <i class="fas fa-robot text-[#0F9D58] text-2xl"></i>
                    </div>
                </div>
                <div>
                    <h3 class="text-xl font-semibold mb-2">Bot Trading</h3>
                    <p class="text-gray-600 mb-4">Automated trading bots execute strategies 24/7. Configure duration, monitor real-time trades, and earn consistent returns without manual intervention.</p>
                </div>
            </div>

            <!-- Stock Trading -->
            <div class="flex flex-col md:flex-row gap-5 md:gap-3 items-start">
                <div class="flex-shrink-0 mr-4">
                    <div class="w-14 h-14 bg-[#E8F5F0] rounded-full flex items-center justify-center">
                        <i class="fas fa-chart-bar text-[#0F9D58] text-2xl"></i>
                    </div>
                </div>
                <div>
                    <h3 class="text-xl font-semibold mb-2">Stock Trading</h3>
                    <p class="text-gray-600 mb-4">Trade global stocks with real-time quotes. Execute market, limit, and stop orders with advanced portfolio management and watchlist features.</p>
                </div>
            </div>

            <!-- Cryptocurrency Trading -->
            <div class="flex flex-col md:flex-row gap-5 md:gap-3 items-start">
                <div class="flex-shrink-0 mr-4">
                    <div class="w-14 h-14 bg-[#E8F5F0] rounded-full flex items-center justify-center">
                        <i class="fab fa-bitcoin text-[#0F9D58] text-2xl"></i>
                    </div>
                </div>
                <div>
                    <h3 class="text-xl font-semibold mb-2">Cryptocurrency Trading</h3>
                    <p class="text-gray-600 mb-4">Trade 100+ cryptocurrencies with instant execution. Advanced order types, custom watchlists, and comprehensive portfolio tracking included.</p>
                </div>
            </div>

            <!-- Crypto Staking -->
            <div class="flex flex-col md:flex-row gap-5 md:gap-3 items-start">
                <div class="flex-shrink-0 mr-4">
                    <div class="w-14 h-14 bg-[#E8F5F0] rounded-full flex items-center justify-center">
                        <i class="fas fa-coins text-[#0F9D58] text-2xl"></i>
                    </div>
                </div>
                <div>
                    <h3 class="text-xl font-semibold mb-2">Crypto Staking</h3>
                    <p class="text-gray-600 mb-4">Earn passive rewards by staking cryptocurrencies. Flexible and locked plans with competitive APR, compound earnings, and hourly/daily rewards.</p>
                </div>
            </div>

            <!-- Stock Investment -->
            <div class="flex flex-col md:flex-row gap-5 md:gap-3 items-start">
                <div class="flex-shrink-0 mr-4">
                    <div class="w-14 h-14 bg-[#E8F5F0] rounded-full flex items-center justify-center">
                        <i class="fas fa-building text-[#0F9D58] text-2xl"></i>
                    </div>
                </div>
                <div>
                    <h3 class="text-xl font-semibold mb-2">Stock Investment</h3>
                    <p class="text-gray-600 mb-4">Long-term stock investment plans targeting major corporations. Systematic ROI distribution with transparent performance tracking and low fees.</p>
                </div>
            </div>

            <!-- Security -->
            <div class="flex flex-col md:flex-row gap-5 md:gap-3 items-start">
                <div class="flex-shrink-0 mr-4">
                    <div class="w-14 h-14 bg-[#E8F5F0] rounded-full flex items-center justify-center">
                        <i class="fas fa-shield-alt text-[#0F9D58] text-2xl"></i>
                    </div>
                </div>
                <div>
                    <h3 class="text-xl font-semibold mb-2">Bank-Grade Security</h3>
                    <p class="text-gray-600 mb-4">Multi-layer security with 2FA authentication, encrypted transactions, cold storage, and KYC verification protecting every investment.</p>
                </div>
            </div>

            <!-- Automation -->
            <div class="flex flex-col md:flex-row gap-5 md:gap-3 items-start">
                <div class="flex-shrink-0 mr-4">
                    <div class="w-14 h-14 bg-[#E8F5F0] rounded-full flex items-center justify-center">
                        <i class="fas fa-cogs text-[#0F9D58] text-2xl"></i>
                    </div>
                </div>
                <div>
                    <h3 class="text-xl font-semibold mb-2">Full Automation</h3>
                    <p class="text-gray-600 mb-4">Automated profit distribution, trade execution, and reward calculations. Set your strategy once and let the system work for you.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Platform Features Showcase -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-14">
            <h4 class="text-[#0F9D58] text-lg mb-2 font-semibold tracking-wide uppercase">PLATFORM CAPABILITIES</h4>
            <h2 class="text-3xl md:text-5xl poppins-light text-gray-900">Everything You Need</h2>
            <h2 class="text-3xl md:text-5xl poppins-medium text-gray-900 mb-3">in One Ecosystem</h2>
            <p class="text-gray-600 max-w-3xl mx-auto mt-3">Comprehensive investment and trading tools designed for both beginners and professional investors seeking consistent returns.</p>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-16">
            <!-- Investment Plans Card -->
            <div class="bg-gradient-to-br from-[#E8F5F0] to-white rounded-2xl p-8 border-2 border-[#0F9D58]/20 hover:border-[#0F9D58] transition-all">
                <div class="flex items-start gap-4 mb-4">
                    <div class="w-16 h-16 bg-[#0F9D58] rounded-xl flex items-center justify-center flex-shrink-0">
                        <i class="fas fa-chart-line text-white text-3xl"></i>
                    </div>
                    <div>
                        <h3 class="text-2xl poppins-medium text-gray-900 mb-2">Investment Plans</h3>
                        <p class="text-[#0F9D58] font-semibold">Daily/Weekly ROI • Multiple Tiers • Automated Distribution</p>
                    </div>
                </div>
                <p class="text-gray-700 leading-relaxed mb-4">Subscribe to flexible investment plans with configurable durations and returns. Our automated system calculates and distributes profits daily or weekly based on your plan's ROI percentage. Cancel anytime and receive your capital back instantly.</p>
                <ul class="space-y-2 text-gray-600">
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Min/Max investment ranges</li>
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Expected return tracking</li>
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Transparent profit history</li>
                </ul>
            </div>

            <!-- Copy Trading Card -->
            <div class="bg-gradient-to-br from-[#E8F5F0] to-white rounded-2xl p-8 border-2 border-[#0F9D58]/20 hover:border-[#0F9D58] transition-all">
                <div class="flex items-start gap-4 mb-4">
                    <div class="w-16 h-16 bg-[#0F9D58] rounded-xl flex items-center justify-center flex-shrink-0">
                        <i class="fas fa-users text-white text-3xl"></i>
                    </div>
                    <div>
                        <h3 class="text-2xl poppins-medium text-gray-900 mb-2">Copy Trading</h3>
                        <p class="text-[#0F9D58] font-semibold">Expert Traders • Win Rate Tracking • Auto-Distribution</p>
                    </div>
                </div>
                <p class="text-gray-700 leading-relaxed mb-4">Follow expert traders and automatically mirror their strategies. Browse trader profiles with performance metrics including ROI percentage, win rate, and active trades. Set your capital limits and let professionals trade for you.</p>
                <ul class="space-y-2 text-gray-600">
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Verified expert traders</li>
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Performance leaderboards</li>
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Capacity management system</li>
                </ul>
            </div>

            <!-- Bot Trading Card -->
            <div class="bg-gradient-to-br from-[#E8F5F0] to-white rounded-2xl p-8 border-2 border-[#0F9D58]/20 hover:border-[#0F9D58] transition-all">
                <div class="flex items-start gap-4 mb-4">
                    <div class="w-16 h-16 bg-[#0F9D58] rounded-xl flex items-center justify-center flex-shrink-0">
                        <i class="fas fa-robot text-white text-3xl"></i>
                    </div>
                    <div>
                        <h3 class="text-2xl poppins-medium text-gray-900 mb-2">Bot Trading</h3>
                        <p class="text-[#0F9D58] font-semibold">24/7 Automation • Multiple Strategies • Real-Time Trades</p>
                    </div>
                </div>
                <p class="text-gray-700 leading-relaxed mb-4">Deploy automated trading bots that execute strategies around the clock. Configure duration from 1-90 days, monitor real-time trades, and earn returns without manual intervention. Bots trade on intervals from 5 minutes to daily.</p>
                <ul class="space-y-2 text-gray-600">
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Pre-configured strategies</li>
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Trade history tracking</li>
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Flexible duration options</li>
                </ul>
            </div>

            <!-- Stock Trading Card -->
            <div class="bg-gradient-to-br from-[#E8F5F0] to-white rounded-2xl p-8 border-2 border-[#0F9D58]/20 hover:border-[#0F9D58] transition-all">
                <div class="flex items-start gap-4 mb-4">
                    <div class="w-16 h-16 bg-[#0F9D58] rounded-xl flex items-center justify-center flex-shrink-0">
                        <i class="fas fa-chart-bar text-white text-3xl"></i>
                    </div>
                    <div>
                        <h3 class="text-2xl poppins-medium text-gray-900 mb-2">Stock Trading</h3>
                        <p class="text-[#0F9D58] font-semibold">Real-Time Quotes • Advanced Orders • Portfolio Management</p>
                    </div>
                </div>
                <p class="text-gray-700 leading-relaxed mb-4">Trade global stocks with real-time price data integration. Execute market, limit, and stop orders with custom expiry options. Manage watchlists, track portfolio performance, and view comprehensive order history.</p>
                <ul class="space-y-2 text-gray-600">
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> TwelveData API integration</li>
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Multiple order types</li>
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Holdings & P/L tracking</li>
                </ul>
            </div>

            <!-- Crypto Trading Card -->
            <div class="bg-gradient-to-br from-[#E8F5F0] to-white rounded-2xl p-8 border-2 border-[#0F9D58]/20 hover:border-[#0F9D58] transition-all">
                <div class="flex items-start gap-4 mb-4">
                    <div class="w-16 h-16 bg-[#0F9D58] rounded-xl flex items-center justify-center flex-shrink-0">
                        <i class="fab fa-bitcoin text-white text-3xl"></i>
                    </div>
                    <div>
                        <h3 class="text-2xl poppins-medium text-gray-900 mb-2">Cryptocurrency Trading</h3>
                        <p class="text-[#0F9D58] font-semibold">100+ Coins • Instant Execution • Custom Watchlists</p>
                    </div>
                </div>
                <p class="text-gray-700 leading-relaxed mb-4">Trade a wide range of cryptocurrencies with instant order execution. Create custom watchlists, monitor price movements, and execute trades with market, limit, or stop orders. Full portfolio tracking included.</p>
                <ul class="space-y-2 text-gray-600">
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Major crypto pairs</li>
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Real-time price updates</li>
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Transaction fee transparency</li>
                </ul>
            </div>

            <!-- Crypto Staking Card -->
            <div class="bg-gradient-to-br from-[#E8F5F0] to-white rounded-2xl p-8 border-2 border-[#0F9D58]/20 hover:border-[#0F9D58] transition-all">
                <div class="flex items-start gap-4 mb-4">
                    <div class="w-16 h-16 bg-[#0F9D58] rounded-xl flex items-center justify-center flex-shrink-0">
                        <i class="fas fa-coins text-white text-3xl"></i>
                    </div>
                    <div>
                        <h3 class="text-2xl poppins-medium text-gray-900 mb-2">Crypto Staking</h3>
                        <p class="text-[#0F9D58] font-semibold">Competitive APR • Compound Earnings • Flexible Terms</p>
                    </div>
                </div>
                <p class="text-gray-700 leading-relaxed mb-4">Earn passive rewards by staking cryptocurrencies. Choose flexible or locked staking plans with durations from 30 days to 1 year. Auto-compound earnings for maximum returns with hourly, daily, or weekly reward intervals.</p>
                <ul class="space-y-2 text-gray-600">
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Multiple lock durations</li>
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Compound interest option</li>
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Early withdrawal penalties</li>
                </ul>
            </div>

            <!-- Stock Investment Card -->
            <div class="bg-gradient-to-br from-[#E8F5F0] to-white rounded-2xl p-8 border-2 border-[#0F9D58]/20 hover:border-[#0F9D58] transition-all">
                <div class="flex items-start gap-4 mb-4">
                    <div class="w-16 h-16 bg-[#0F9D58] rounded-xl flex items-center justify-center flex-shrink-0">
                        <i class="fas fa-building text-white text-3xl"></i>
                    </div>
                    <div>
                        <h3 class="text-2xl poppins-medium text-gray-900 mb-2">Stock Investment</h3>
                        <p class="text-[#0F9D58] font-semibold">Long-Term Plans • Blue Chip Stocks • Systematic ROI</p>
                    </div>
                </div>
                <p class="text-gray-700 leading-relaxed mb-4">Invest in curated stock plans targeting major corporations. Long-term investment approach with systematic ROI distribution. Transparent performance tracking with detailed company information and stock symbol identification.</p>
                <ul class="space-y-2 text-gray-600">
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Major corporation focus</li>
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Systematic returns</li>
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Low transaction fees</li>
                </ul>
            </div>

            <!-- Security & Automation Card -->
            <div class="bg-gradient-to-br from-[#E8F5F0] to-white rounded-2xl p-8 border-2 border-[#0F9D58]/20 hover:border-[#0F9D58] transition-all">
                <div class="flex items-start gap-4 mb-4">
                    <div class="w-16 h-16 bg-[#0F9D58] rounded-xl flex items-center justify-center flex-shrink-0">
                        <i class="fas fa-shield-check text-white text-3xl"></i>
                    </div>
                    <div>
                        <h3 class="text-2xl poppins-medium text-gray-900 mb-2">Security & Automation</h3>
                        <p class="text-[#0F9D58] font-semibold">2FA • KYC Verification • Automated Jobs</p>
                    </div>
                </div>
                <p class="text-gray-700 leading-relaxed mb-4">Enterprise-grade security protecting all investments. Two-factor authentication, KYC verification, encrypted transactions, and automated scheduled jobs for profit distribution, trade execution, and reward calculations.</p>
                <ul class="space-y-2 text-gray-600">
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Multi-layer security</li>
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Background job processing</li>
                    <li class="flex items-center gap-2"><i class="fas fa-check text-[#0F9D58]"></i> Instant notifications</li>
                </ul>
            </div>
        </div>
    </div>
</section>

<!-- Investment Plans Section -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-14">
            <h4 class="text-[#0F9D58] text-lg mb-2 font-semibold tracking-wide uppercase">INVESTMENT OPTIONS</h4>
            <h2 class="text-3xl md:text-5xl poppins-light text-gray-900">Choose Your</h2>
            <h2 class="text-3xl md:text-5xl poppins-medium text-gray-900 mb-3">Investment Strategy</h2>
            <p class="text-gray-600 max-w-2xl mx-auto mt-3">Start with any plan and diversify across multiple investment vehicles for maximum returns.</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-10">
            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="relative group bg-white rounded-2xl shadow-lg border border-gray-200 transition duration-300 hover:scale-[1.03] hover:shadow-2xl overflow-hidden">
                    <!-- Green accent bar at top -->
                    <div class="h-2 bg-gradient-to-r from-[#0F9D58] to-[#0B8046]"></div>
                    
                    <div class="p-8 text-center">
                        <h3 class="text-2xl poppins-medium text-gray-900 mb-2"><?php echo e($plan->name); ?></h3>
                        
                        <div class="text-3xl font-bold text-[#0F9D58] mb-2">
                            $<?php echo e(number_format($plan->min_price, 2)); ?> - $<?php echo e(number_format($plan->max_price, 2)); ?>

                        </div>

                        <div class="text-gray-500 text-sm mb-6">Min &mdash; Max Investment</div>

                        <div class="bg-[#E8F5F0] rounded-lg p-4 mb-6">
                            <ul class="text-gray-700 text-sm space-y-3">
                                <li class="flex items-center justify-between">
                                    <span class="font-medium text-gray-900">Daily ROI:</span>
                                    <span class="text-[#0F9D58] font-bold"><?php echo e($plan->increment_amount); ?>%</span>
                                </li>
                                <li class="flex items-center justify-between">
                                    <span class="font-medium text-gray-900">Expected Return:</span>
                                    <span class="text-[#0F9D58] font-bold"><?php echo e($plan->expected_return); ?>%</span>
                                </li>
                            </ul>
                        </div>

                        <a href="<?php echo e(route('register')); ?>" class="inline-block w-full px-6 py-3 bg-[#0F9D58] text-white rounded-full font-medium hover:bg-[#0B8046] transition-all shadow-md hover:shadow-lg">
                            Get Started
                        </a>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- How It Works Section -->
<section class="manrope text-sm relative py-16 w-full h-fit overflow-hidden" style="background: linear-gradient(180deg, #ffffff 0%, #e8f5f0 100%);">
    <img src="<?php echo e(asset('temp/assets/images/assets-blob-1.svg')); ?>" alt="" class="absolute bottom-0 right-0 w-[400px] md:w-[500px] opacity-30">
    
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div class="max-w-7xl mx-auto">
            <div class="text-center mb-12">
                <h2 class="text-sm font-semibold text-[#0F9D58] mb-2">GETTING STARTED</h2>
                <h1 class="text-3xl md:text-5xl poppins-light text-gray-900">How the Platform</h1>
                <h1 class="text-3xl md:text-5xl poppins-medium text-gray-900 mb-4">Works for You</h1>
                <p class="text-gray-600 max-w-2xl mx-auto">Start earning across multiple investment channels in four simple steps</p>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <!-- Image -->
                <div class="order-2 lg:order-1">
                    <img src="assets/img/service/single-service-1.jpg" alt="Investment Platform" class="w-full h-auto rounded-lg shadow-xl">
                </div>

                <!-- Steps -->
                <div class="order-1 lg:order-2 space-y-6">
                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0">
                            <div class="w-12 h-12 bg-[#0F9D58] rounded-full flex items-center justify-center text-white font-bold text-xl">1</div>
                        </div>
                        <div>
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Create & Verify Account</h3>
                            <p class="text-gray-600">Sign up in minutes with email verification. Complete KYC for full access to all trading and investment features with enhanced security.</p>
                        </div>
                    </div>

                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0">
                            <div class="w-12 h-12 bg-[#0F9D58] rounded-full flex items-center justify-center text-white font-bold text-xl">2</div>
                        </div>
                        <div>
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Fund Your Account</h3>
                            <p class="text-gray-600">Deposit funds via cryptocurrency, bank transfer, or card payment. Multiple payment gateways ensure fast, secure transactions with instant confirmation.</p>
                        </div>
                    </div>

                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0">
                            <div class="w-12 h-12 bg-[#0F9D58] rounded-full flex items-center justify-center text-white font-bold text-xl">3</div>
                        </div>
                        <div>
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Choose Your Strategy</h3>
                            <p class="text-gray-600">Select from investment plans, copy top traders, deploy trading bots, trade stocks/crypto, stake assets, or combine multiple strategies for diversification.</p>
                        </div>
                    </div>

                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0">
                            <div class="w-12 h-12 bg-[#0F9D58] rounded-full flex items-center justify-center text-white font-bold text-xl">4</div>
                        </div>
                        <div>
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Monitor & Withdraw Profits</h3>
                            <p class="text-gray-600">Track real-time performance across all investments. Withdraw profits anytime to your wallet, reinvest for compound growth, or reallocate to different strategies.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Call to Action Section -->
<section class="overflow-hidden bg-white">
    <div class="p-5 md:p-20">
        <div class="relative px-5 md:px-10 lg:px-20 pb-10 md:pb-20 py-10 md:py-16 manrope text-sm text-white container mx-auto flex flex-col md:flex-row gap-8 md:gap-5 items-center md:items-end justify-between w-full rounded-xl md:rounded-3xl shadow-2xl" style="background: linear-gradient(226deg, rgb(1, 5, 34) 50.68%, rgb(15, 157, 88) 84.75%);">
            <div class="w-full md:flex-1 space-y-5 z-10">
                <div class="text-3xl md:text-4xl lg:text-5xl xl:text-6xl poppins-medium text-left">Start your wealth journey <div class="poppins-light mt-2">with <?php echo e($settings->site_name); ?></div></div>
                <p class="text-lg md:text-xl text-gray-200">Join thousands of investors earning consistent returns through diversified investment strategies across seven powerful platforms.</p>
                <a href="<?php echo e(route('register')); ?>" class="inline-block py-2 text-white text-xl md:text-2xl lg:text-3xl hover:underline transition-all">Create Free Account <i class="fa-solid fa-arrow-right-long ml-2"></i></a>
            </div>
            <div class="relative w-full md:flex-1 flex justify-center md:justify-end min-h-[300px] md:min-h-[400px]">
                <img src="<?php echo e(asset('temp/assets/images/man-shades.webp')); ?>" alt="Happy Investor" class="w-[280px] md:w-[400px] lg:w-[500px] z-20 relative object-contain">
                <img src="<?php echo e(asset('temp/assets/images/not.webp')); ?>" alt="Profit Notification" class="w-[120px] md:w-[200px] lg:w-[300px] absolute top-[20%] md:top-1/2 right-0 md:right-[-50px] lg:right-[-80px] -translate-y-1/2 z-[30] object-contain">
                <img src="<?php echo e(asset('temp/assets/images/smaller-not.webp')); ?>" alt="Investment Preview" class="w-[100px] md:w-[160px] lg:w-[250px] absolute top-[60%] md:top-1/2 right-[20px] md:right-[10px] translate-y-[-20%] md:translate-y-[20px] z-[22] object-contain">
            </div>
        </div>
    </div>
</section>

<!-- Counter Section -->
<section class="py-16 bg-[#0F9D58] text-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-10">
            <h2 class="text-2xl md:text-4xl poppins-medium mb-2">Platform Statistics</h2>
            <p class="text-white/80">Real numbers from real investors</p>
        </div>
        <div class="grid grid-cols-2 md:grid-cols-4 gap-8">
            <div class="text-center">
                <div class="text-3xl md:text-5xl font-bold mb-2">
                    <span class="counter" data-count="9430">0</span>+
                </div>
                <p class="text-sm md:text-lg">Active Investors</p>
            </div>

            <div class="text-center">
                <div class="text-3xl md:text-5xl font-bold mb-2">
                    $<span class="counter" data-count="338">0</span>M+
                </div>
                <p class="text-sm md:text-lg">Total Invested</p>
            </div>

            <div class="text-center">
                <div class="text-3xl md:text-5xl font-bold mb-2">
                    $<span class="counter" data-count="101">0</span>M+
                </div>
                <p class="text-sm md:text-lg">Total Withdrawn</p>
            </div>

            <div class="text-center">
                <div class="text-3xl md:text-5xl font-bold mb-2">
                    <span class="counter" data-count="2145">0</span>+
                </div>
                <p class="text-sm md:text-lg">Days in Operation</p>
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // Counter Animation
    function animateCounters() {
        $('.counter').each(function() {
            var $this = $(this);
            var countTo = parseInt($this.attr('data-count'));

            $({ countNum: 0 }).animate({
                countNum: countTo
            }, {
                duration: 2000,
                easing: 'swing',
                step: function() {
                    $this.text(Math.floor(this.countNum).toLocaleString());
                },
                complete: function() {
                    $this.text(countTo.toLocaleString());
                }
            });
        });
    }

    function checkCounters() {
        const counterSection = $('.counter').first().closest('section');
        if (counterSection.length) {
            const sectionTop = counterSection.offset().top;
            const windowTop = $(window).scrollTop();
            const windowHeight = $(window).height();

            if (windowTop + windowHeight > sectionTop + 100) {
                animateCounters();
                $(window).off('scroll', checkCounters);
            }
        }
    }

    $(window).on('scroll', checkCounters);
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/complex3/domains/remedybermbypromax.sbs/public_html/resources/views/home/investment.blade.php ENDPATH**/ ?>