const TerserPlugin = require('terser-webpack-plugin');
const webpack = require('webpack');
const path = require('path');

const optimization = {
  minimize: true,
  minimizer: [
    new TerserPlugin({
      terserOptions: {
        mangle: false,
        compress: {
          keep_fnames: true,
        },
      },
    }),
  ],
};

/* configs */
const swcWebESM = require('./swc/swcrc.esm');
const webESM = {
  mode: 'production',
  entry: './lib/index.es6',
  devtool: 'source-map',
  
  target: 'web',

  module: {
    rules: [
      {
        loader: 'swc-loader',
        options: swcWebESM,
        test: /\.es6$/,
        exclude: /(node_modules)/
      }
    ]
  },

  output: {
    filename: 'index.js',
    path: path.resolve(__dirname, './dists/esm-web/'),
    library: {
      type: 'module',
    }
  },

  experiments: {
    outputModule: true,
  },

  plugins: [
    new webpack.DefinePlugin({
      'process.env.NODE_DEBUG': false,
      'process.env.IS_BROWSER': true
    }),
    new webpack.ProvidePlugin({
      Buffer: ['buffer', 'Buffer'],
      process: 'process/browser',
    }),
  ],

  resolve: {
    extensions: ['.es6', '.js'],
    alias: {
      process: 'process/browser',
      '@HistoryDatabase': './browserHistoryDatabase',
      '@axios': 'axios',
    },
    fallback: {
      stream: require.resolve('stream-browserify'),
      buffer: require.resolve('buffer'),
      util: require.resolve('util'),
      fs: false,
      assert: false,
      constants: false,
      crypto: false,
      http: false,
      https: false,
      process: false,
      url: false,
      zlib: false,
      path: false,
      net: false,
      os: false,
      tls: false,
      tty: false,
      cluster: false,
      querystring: false
    },
  },

  optimization
};

const swcrcUMD = require('./swc/swcrc.umd');
const webUMD = {
  entry: './lib/index.es6',
  target: 'web',
  mode: 'production',
  devtool: 'source-map',
  
  module: {
    rules: [
      {
        loader: 'swc-loader',
        test: /\.es6$/,
        exclude: /(node_modules)/,
        options: swcrcUMD
      }
    ]
  },

  output: {
    filename: 'index.js',
    path: path.resolve(__dirname, './dists/umd/'),
    globalObject: 'this',
    library: {
      name: 'MetaApi',
      type: 'umd'
    }
  },

  plugins: [
    new webpack.DefinePlugin({
      'process.env.NODE_DEBUG': false,
      'process.env.IS_BROWSER': true
    }),
    new webpack.ProvidePlugin({
      Buffer: ['buffer', 'Buffer'],
      process: 'process/browser'
    }),
  ],

  resolve: {
    extensions: ['.es6', '.js'],
    alias: {
      process: 'process/browser',
      '@HistoryDatabase': './browserHistoryDatabase',
      '@axios': 'axios',
      'metaapi.cloud-metastats-sdk': 'metaapi.cloud-metastats-sdk/web',
      'metaapi.cloud-copyfactory-sdk': 'metaapi.cloud-copyfactory-sdk/web'
  
    },
    fallback: {
      stream: require.resolve('stream-browserify'),
      buffer: require.resolve('buffer'),
      util: require.resolve('util'),
      fs: false,
      assert: false,
      constants: false,
      crypto: false,
      http: false,
      https: false,
      process: false,
      url: false,
      zlib: false,
      path: false,
      net: false,
      os: false,
      tls: false,
      tty: false,
      cluster: false,
      querystring: false
    },
  },

  optimization
};

const swcNodeESM = require('./swc/swcrc.esm');
const nodeESM = {
  mode: 'production',
  entry: './lib/index.es6',
  devtool: 'source-map',

  target: 'node16',

  module: {
    rules: [
      {
        loader: 'swc-loader',
        options: swcNodeESM,
        test: /\.(es6)|(ts)$/,
        exclude: /(node_modules)/
      }
    ]
  },

  output: {
    filename: 'index.mjs',
    path: path.resolve(__dirname, './dists/esm-node/'),
    library: {
      type: 'module'
    }
  },

  experiments: {
    outputModule: true
  },

  plugins: [
    new webpack.DefinePlugin({
      'process.env.IS_BROWSER': false
    })
  ],

  resolve: {
    extensions: ['.es6', '.js'],
    alias: {
      '@HistoryDatabase': './filesystemHistoryDatabase',
      '@axios': 'axios',
      'metaapi.cloud-copyfactory-sdk': 'metaapi.cloud-copyfactory-sdk/esm',
      'metaapi.cloud-metastats-sdk': 'metaapi.cloud-metastats-sdk/esm'
    }
  },

  optimization
};

const swcrcCJS = require('./swc/swcrc.cjs');
const nodeCJS = {
  entry: './lib/index.es6',
  target: 'node',
  mode: 'production',
  devtool: 'source-map',

  module: {
    rules: [
      {
        loader: 'swc-loader',
        test: /\.es6$/,
        exclude: /(node_modules)/,
        options: swcrcCJS
      }
    ]
  },

  output: {
    filename: 'index.js',
    path: path.resolve(__dirname, './dists/cjs/'),
    library: {
      type: 'commonjs'
    }
  },
  
  resolve: {
    extensions: ['.es6', '.js'],
    alias: {
      '@HistoryDatabase': './filesystemHistoryDatabase',
      '@axios': 'axios'
    }
  },

  plugins: [
    new webpack.DefinePlugin({
      'process.env.IS_BROWSER': false
    })
  ],

  optimization
};

module.exports = [ webESM, webUMD, nodeESM, nodeCJS ];
