"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return EquityBalanceListener;
    }
});
let EquityBalanceListener = class EquityBalanceListener {
    /**
   * Returns account id
   */ get accountId() {
        return this._accountId;
    }
    /**
   * Processes an update event when equity or balance changes
   * @param {EquityBalanceData} equityBalanceData equity and balance updated data
   */ async onEquityOrBalanceUpdated(equityBalanceData) {
        throw Error("Abstract method onEquityOrBalanceUpdated has no implementation");
    }
    /**
   * Processes an event which occurs when connection has been established
   */ async onConnected() {
        throw Error("Abstract method onConnected has no implementation");
    }
    /**
   * Processes an event which occurs when connection has been lost
   */ async onDisconnected() {
        throw Error("Abstract method onDisconnected has no implementation");
    }
    /**
   * Processes an error event
   * @param {Error} error error received 
   */ async onError(error) {}
    /**
   * Creates an equity chart listener instance
   * @param {string} accountId account id
   */ constructor(accountId){
        if (!accountId) {
            throw Error("Account id parameter required");
        }
        this._accountId = accountId;
    }
};

//# sourceMappingURL=data:application/json;base64,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