'use strict';
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
import HttpClient from './clients/httpClient';
import DomainClient from './clients/domain.client';
import MetaStatsClient from './clients/metaStats.client';
let MetaStats = class MetaStats {
    /**
   * Returns the getMetrics MetaStatsClient method bound to the MetaStatsClient instance
   * @returns {Function} getMetrics MetaStatsClient method
   */ get getMetrics() {
        return this._metaStatsClient.getMetrics.bind(this._metaStatsClient);
    }
    /**
   * Returns the getAccountTrades MetaStatsClient method bound to the MetaStatsClient instance
   * @returns {Function} getAccountTrades MetaStatsClient method
   */ get getAccountTrades() {
        return this._metaStatsClient.getAccountTrades.bind(this._metaStatsClient);
    }
    /**
   * Returns the getAccountOpenTrades MetaStatsClient method bound to the MetaStatsClient instance
   * @returns {Function} getAccountOpenTrades MetaStatsClient method
   */ get getAccountOpenTrades() {
        return this._metaStatsClient.getAccountOpenTrades.bind(this._metaStatsClient);
    }
    /**
   * Returns the resetMetrics MetaStatsClient method bound to the MetaStatsClient instance
   * @returns {Function} resetMetrics MetaStatsClient method
   */ get resetMetrics() {
        return this._metaStatsClient.resetMetrics.bind(this._metaStatsClient);
    }
    /**
   * Constructs MetaStats class instance
   * @param {String} token authorization token
   * @param {ConnectionOptions} [opts] connection options
   */ constructor(token, opts = {}){
        _define_property(this, "_metaStatsClient", void 0);
        const httpClient = new HttpClient(opts.requestTimeout, opts.retryOpts);
        const domainClient = new DomainClient(httpClient, token, opts.domain);
        this._metaStatsClient = new MetaStatsClient(domainClient);
    }
};
/**
 * MetaStats API SDK
 */ export { MetaStats as default };

//# sourceMappingURL=data:application/json;base64,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