'use strict';

import sinon from 'sinon';
import SubscriberSignalClient from './subscriberSignal.client';
 
/**
 * @test {SubscriberSignalClient}
 */
describe('SubscriberSignalClient', () => {
 
  let subscriberSignalClient;
  const token = 'header.payload.sign';
  let domainClient;
  let host = {
    host: 'https://copyfactory-api-v1',
    region: 'vint-hill',
    domain: 'agiliumtrade.ai'
  };
  let requestStub;

  /**
    * @test {SubscriberSignalClient#getTradingSignals}
    */
  it('should retrieve signals', async () => {
    domainClient = {
      token: token,
      requestSignal: () => {}
    };
    subscriberSignalClient = new SubscriberSignalClient('accountId', host, domainClient);
    requestStub = sinon.stub(domainClient, 'requestSignal');
    const expected = [{
      symbol: 'EURUSD',
      type: 'POSITION_TYPE_BUY',
      time: '2020-08-24T00:00:00.000Z',
      closeAfter: '2020-08-24T00:00:00.000Z',
      volume: 1
    }];
    requestStub.resolves(expected);
    let stopouts = await subscriberSignalClient.getTradingSignals();
    stopouts.should.equal(expected);
    sinon.assert.calledOnceWithExactly(domainClient.requestSignal, {
      url: '/users/current/subscribers/accountId/signals',
      method: 'GET',
      headers: {
        'auth-token': token
      },
      json: true,
    }, host, 'accountId');
  });
 
});
 